import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;

@SuppressWarnings({"Convert2Lambda", "CodeBlock2Expr"})
public class UseFilenameFilter {
    public static void main(String[] args) {
        File directory = new File("./src/main/java");
        System.out.println(directory.getAbsolutePath());

        // anonimowa klasa wewntrzna
        String[] names = directory.list(new FilenameFilter() {
            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        System.out.println(Arrays.asList(names));

        // uycie wyraenia lambda
        names = directory.list((dir, name) -> name.endsWith(".java"));
        System.out.println(Arrays.asList(names));

        // bezporednie typy danych
        names = directory.list((File dir, String name) -> name.endsWith(".java"));
        System.out.println(Arrays.asList(names));

        names = directory.list((File dir, String name) -> {
            return name.endsWith(".java");
        });
        System.out.println(Arrays.asList(names));
    }
}
