import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Iteration {
    public static void main(String[] args) {
        List<Integer> integers = Arrays.asList(3, 1, 4, 1, 5, 9);

        // Implementuje Consumer przy uyciu anonimowej klasy wewntrznej
        integers.forEach(new Consumer<Integer>() {
            @Override
            public void accept(Integer integer) {
                System.out.println(integer);
            }
        });

        // pena duga wersja lambdy
        integers.forEach((Integer n) -> {
            System.out.println(n);
        });

        // uproszczona forma lambdy
        integers.forEach(n -> System.out.println(n));

        // referencja do metody
        integers.forEach(System.out::println);

        Map<Long, String> map = new HashMap<>();
        map.put(86L, "Don Adams (Maxwell Smart)");
        map.put(99L, "Barbara Feldon");
        map.put(13L, "David Ketchum");

        map.forEach((num, agent) ->
                System.out.printf("Agent %d, grany przez %s%n", num, agent));
    }
}
