package collectors;

import org.junit.Test;

import java.util.List;
import java.util.Set;

import static org.junit.Assert.*;

@SuppressWarnings("Duplicates")
public class ImmutableCollectionsTest {
    private ImmutableCollections demo = new ImmutableCollections();

    @Test(expected = UnsupportedOperationException.class)
    public void createImmutableList() throws Exception {
        List<String> list = demo.createImmutableList("to", "jest", "lista", "acuchw");
        assertEquals(4, list.size());
        assertEquals("to", list.get(0));
        assertEquals("jest",   list.get(1));
        assertEquals("lista",    list.get(2));
        assertEquals("acuchw", list.get(3));
        list.add("extra");
    }

    @Test(expected = UnsupportedOperationException.class)
    public void createImmutableListJava7() throws Exception {
        List<String> list = demo.createImmutableListJava7("to", "jest", "lista", "acuchw");
        assertEquals(4, list.size());
        assertEquals("to", list.get(0));
        assertEquals("jest",   list.get(1));
        assertEquals("lista",    list.get(2));
        assertEquals("acuchw", list.get(3));
        list.add("extra");
    }

    @Test(expected = UnsupportedOperationException.class)
    public void createImmutableSet() throws Exception {
        Set<String> set = demo.createImmutableSet("a", "b", "b", "c");
        assertEquals(3, set.size());
        assertTrue(set.contains("a"));
        assertTrue(set.contains("b"));
        assertTrue(set.contains("c"));
        set.add("d");
    }

    @Test(expected = UnsupportedOperationException.class)
    public void createImmutableSetJava7() throws Exception {
        Set<String> set = demo.createImmutableSetJava7("a", "b", "b", "c");
        assertEquals(3, set.size());
        assertTrue(set.contains("a"));
        assertTrue(set.contains("b"));
        assertTrue(set.contains("c"));
        set.add("d");
    }

    @Test(expected = UnsupportedOperationException.class)
    public void immutableMap() throws Exception {
        demo.map.put("a", 5);
    }

}