package streams;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class ReduceDemo {
    @SuppressWarnings("Convert2MethodRef")
    public static void main(String[] args) {
        int sum = IntStream.rangeClosed(1, 10)
                .reduce((x, y) -> x + y).orElse(0);
        System.out.println(sum);

        sum = IntStream.rangeClosed(1, 10)
                .reduce((x, y) -> {
                    System.out.printf("x=%d, y=%d%n", x, y);
                    return x + y;
                }).orElse(0);

        sum = IntStream.rangeClosed(1, 10)
                .reduce(Integer::sum).orElse(0);
//
//        sum = Stream.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
//                .reduce(0, Integer::sum);
//
//
//        // pomyka o jeden: pierwsza warto nie zostaa podwojona
        int doubleSum = IntStream.rangeClosed(1, 10)
                .reduce((acc, n) -> acc + 2 * n).orElse(0);
        System.out.println(doubleSum);

        doubleSum = IntStream.rangeClosed(1, 10)
                .reduce(0, (acc, n) -> {
                    System.out.printf("Acc=%d, n=%d%n", acc, n);
                    return acc + 2 * n;
                });
        System.out.println(doubleSum);

        doubleSum = IntStream.rangeClosed(1, 10)
                .reduce(0, Integer::sum);
        System.out.println(doubleSum);

        BigDecimal total = Stream.iterate(BigDecimal.ONE, n -> n.add(BigDecimal.ONE))
                .limit(10)
                .reduce(BigDecimal.ZERO, (acc, val) -> {
                    System.out.println("acc=" + acc + ", val=" + val);
                    return acc.add(val);
                });
        System.out.println("total wynosi " + total);

        Integer max = Stream.of(3, 1, 4, 1, 5, 9)
                .reduce(Integer.MIN_VALUE, Integer::max);
        System.out.println("Warto maksymalna wynosi " + max);


        /* przykad z uyciem String */
        // mao efektywne, ale dziaa
        String s = Stream.of("to", "jest", "lista", "acuchw")
                .reduce("", String::concat);
        System.out.println(s);

        // lepsze, ale dugie
        s = Stream.of("to", "jest", "lista", "acuchw")
                .collect(() -> new StringBuilder(),
                        (sb, str) -> sb.append(str),
                        (sb1, sb2) -> sb1.append(sb2))
                .toString();

        // lepsze i prostsze
        s = Stream.of("to", "jest", "lista", "acuchw")
                .collect(StringBuilder::new,
                        StringBuilder::append,
                        StringBuilder::append)
                .toString();

        // najlepsze (a przynajmniej najprostsze)
        s = Stream.of("to", "jest", "lista", "acuchw")
                .collect(Collectors.joining());


        List<Book> books = Arrays.asList(
                new Book(1, "Modern Java Recipes"),
                new Book(2, "Making Java Groovy"),
                new Book(3, "Gradle Recipes for Android"));

        // Uwaga: to jest trudne; zobacz AddCollectionToMap, jeli szukasz atwiejszych sposobw
        SortedMap<Integer, Book> bookMap = books.stream()
                .reduce(new TreeMap<Integer, Book>(),  // tosame z putAll
                        (map, book) -> {               // dodaje jedn ksik do sownika
                            map.put(book.getId(), book);
                            return map;
                        },
                        (map1, map2) -> {              // czy wiele sownikw
                            map1.putAll(map2);
                            return map1;
                        });

        bookMap.forEach((k,v) -> System.out.println(k + ": " + v));

    }
}
