package lambdas;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;

@SuppressWarnings("Convert2MethodRef")
public class LambdasDemo {
    // @SuppressWarnings("Convert2MethodRef")
    public static void main(String[] args) {
        List<String> strings = Arrays.asList("to", "jest", "strumie", "acuchw", "tekstowych");

        // Java 7
        System.out.println("Printing using anonymous inner class:");
        strings.forEach(new Consumer<String>() {
            @Override
            public void accept(String s) {
                System.out.println(s);
            }
        });

        // forEach pobiera Consumer
        // duga skadnia lambdy (lambda blokowa)
        strings.forEach((String s) -> {
            System.out.println(s);
        });

        // uproszczona skadnia lambdy (wyraenie lambda)
        System.out.println("Drukowanie za pomoc wyraenia lambda:");
        strings.forEach(s -> System.out.println(s));

        System.out.println("Drukowanie za pomoc referencji do metody:");
        strings.forEach(System.out::println);

        int totalLength = strings.stream()
                .mapToInt(String::length)
                .sum();
        System.out.printf("Sumaryczna dugo wszystkich acuchw wynosi %d%n", totalLength);

        Stream.of(3, 1, 4, 1, 5, 9)
                .forEach(System.out::println);

        // osobna definicja konsumenta
        Consumer<Integer> printer = n -> System.out.println(n);
        Stream.of(3, 1, 4, 1, 5, 9)
                .forEach(printer);

        System.out.println();
        // predykat zwraca warto logiczn
        Predicate<Integer> mod3 = n -> n % 3 == 0;
        Stream.of(3, 1, 4, 1, 5, 9)
                .filter(mod3)
                .forEach(printer);

        System.out.println();
        // funkcja jednego typu zwraca jeden typ
        IntUnaryOperator doubler = n -> n * 2;
        int sum = IntStream.range(1, 10)
                .filter(n -> n % 3 == 0)
                .peek(n -> System.out.println("Po filtrze: " + n))
                .map(doubler)
                .peek(n -> System.out.println("Po podwajaczu: " + n))
                .sum();
        System.out.println("Suma wynosi " + sum);
    }
}
