package lambdas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ClosureVariables {

    private static boolean isEvenLength(String s) {
        try {
            Thread.sleep(100);
        } catch (InterruptedException ignored) {
        }
        System.out.printf("%s z %s%n", Thread.currentThread().getName(), s);
        return s.length() % 2 == 0;
    }

    @SuppressWarnings({"Convert2streamapi", "UnusedAssignment", "unused"})
    public static void main(String[] args) {

        // sumowanie za pomoc ptli (iteracyjne i wsplny zmienny stan)
        int total = 0;
        List<Integer> nums = Arrays.asList(3, 1, 4, 1, 5, 9, 2, 6, 5);
        for (int n : nums) {
            total += n;
        }
        System.out.printf("The total is %d%n", total);

        // funkcyjne, ale wsplny zmienny stan (nie przejdzie kompilacji)
        total = 0;
        nums.forEach(n -> {
                    // nie mona zmodyfikowa total
                    // total += n;
                }
        );

        // funkcyjne, brak wsplnego zmiennego stanu
        total = nums.stream()
                .mapToInt(Integer::valueOf)
                .sum();
        System.out.printf("Warto total wynosi %d%n", total);

        // znajduje acuchy o parzystej dugoci
        List<String> strings = Arrays.asList("to", "jest", "strumie", "acuchw", "tekstowych");
        Predicate<String> evenlengths = (String s) -> {
            try {
                Thread.sleep(100);
            } catch (InterruptedException ignored) {
            }
            System.out.println(Thread.currentThread().getName());
            return s.length() % 2 == 0;
        };


        // skutki uboczne --> dozwolone, ale niebezpieczne
        List<String> evenLengths = new ArrayList<>();
        strings.stream()
                .filter(s -> s.length() % 2 == 0)
                .forEach(evenLengths::add);
        System.out.println(evenLengths);

        // brak skutkw ubocznych
        evenLengths = strings.stream()
                .filter(s -> s.length() % 2 == 0)
                .collect(Collectors.toList());
        System.out.println(evenLengths);


        // brak skutkw ubocznych
        long start = System.nanoTime();
        List<String> evens = strings.parallelStream()
                .filter(ClosureVariables::isEvenLength)
                //.filter(s -> s.length() % 2 == 0)
                .collect(Collectors.toList());
        long end = System.nanoTime();
        System.out.println(evens);
        System.out.printf("Czas: %s%s%n", (end - start) / 1e9, "sec");


    }
}
