// test.js
// Skrypt wykonuje żądanie Ajax i uaktualnia stronę WWW otrzymanym wynikiem.

// Ustaw podstawową funkcjonalność po wczytaniu strony:
window.onload = function() {
    'use strict';

	// Utwórz obiekt Ajax:
	var ajax = getXMLHttpRequestObject();
	
	// Funkcja wywoływana w przypadku zmian właściwości readyState:
	ajax.onreadystatechange = function() {

		// Sprawdź właściwość readyState:
		if (ajax.readyState == 4) {
			
			// Sprawdź kod statusu:
		    if ( (ajax.status >= 200 && ajax.status < 300) 
		    || (ajax.status == 304) ) {
			
				// Uaktualnij stronę WWW:
				// Wersja tekstowa:
//				document.getElementById('output').innerHTML = ajax.responseText;
	
				// Wersja XML:
				var data = ajax.responseXML;
				console.log(data.documentElement.firstChild.nextSibling.firstChild.nodeValue);
				var chapters = data.getElementsByTagName('chapter');
				var str = '';
				for (var i = 0, count = chapters.length; i < count; i++) {
				    // Użyj wartości chapters[i].id i chapters[i].value.
					str += 'Rozdział ' + chapters[i].getAttribute('id') + '. ' + chapters[i].firstChild.nodeValue + '<br>'
				}
				document.getElementById('output').innerHTML = str;
				
				// Wersja JSON:
				/*
				var data = JSON.parse(ajax.responseText);
				var str = '';
				str += 'Rozdział 1. ' + data[1].title + '<br>'
				str += 'Rozdział 2. ' + data[2].title + '<br>'
				document.getElementById('output').innerHTML = str;
				*/
				
		    } else { // Błędny status!
				document.getElementById('output').innerHTML = ajax.statusText;
		    }
					
		} // Koniec warunku IF.

	}; // Koniec funkcji anonimowej dla onreadystatechange.

    // Dodaj procedurę obsługi kliknięcia przycisku:
    document.getElementById('btn').onclick = function() {

		// Rozpocznij żądanie:
	    ajax.open('GET', 'zasoby/test.xml', true);
	
		// Wyślij żądanie:
		ajax.send(null);
		
	}; // Koniec funkcji anonimowej dla onclick.
    
}; // Koniec funkcji anonimowej dla onload.