// utilities.js
// Skrypt definiuje obiekt z kilkoma przydatnymi funkcjami.

var U = {

    // Pobiera referencję do elementu na podstawie jego identyfikatora:
    $: function(id) {
        'use strict';
        if (typeof id == 'string') {
            return document.getElementById(id);
        }
    }, // Koniec funkcji $().

    // Funkcja ustawiająca tekst elementu:
    setText: function(id, message) {
        'use strict';
        if ( (typeof id == 'string')
        && (typeof message == 'string') ) {
    
            // Pobierz referencję do elementu:
            var output = this.$(id);
            if (!output) return false;
        
            // Ustaw tekst:
            if (output.textContent !== undefined) {
                output.textContent = message;
            } else {
                output.innerText = message;
            }
            return true;
        } // Koniec IF.
    }, // Koniec funkcji setText().
    
    // Funkcja przypisująca procedurę obsługi:
    addEvent: function(obj, type, fn) {
        'use strict';
        if (obj && obj.addEventListener) { // W3C
            obj.addEventListener(type, fn, false);
        } else if (obj && obj.attachEvent) { // starsze IE
            obj.attachEvent('on' + type, fn);
        }
    }, // Koniec funkcji addEvent().
    
    // Funkcja usuwająca procedurę obsługi:
    removeEvent: function(obj, type, fn) {
        'use strict';
        if (obj && obj.removeEventListener) { // W3C
            obj.removeEventListener(type, fn, false);
        } else if (obj && obj.detachEvent) { // starsze IE
            obj.detachEvent('on' + type, fn);
        }
    }, //Koniec funkcji removeEvent().

	// Funkcja tworząca obiekt Ajax:
	getXMLHttpRequestObject: function() {

	    var ajax = null;

		// Większość przeglądarek:
		if (window.XMLHttpRequest) {
		    ajax = new XMLHttpRequest();
		} else if (window.ActiveXObject) { // Starsze IE:
		    ajax = new ActiveXObject('MSXML2.XMLHTTP.3.0');
		}

		// Zwróć obiekt:
	    return ajax;

	} // Koniec funkcji getXMLHttpRequestObject().
	
}; // Koniec deklaracji U.