// cookies.js
// Skrypt definiuje funkcje związane z obsługą ciasteczek (cookies).

// Utwórz jededen, globalny obiekt:
var COOKIE = {
    
    // Funkcja ustawia nowe cookie:
    setCookie: function(name, value, expire) {
        'use strict';

        // Dodaj walidację!

        // Rozpocznij tworzenie końcowego tekstu:
        var str =  encodeURIComponent(name) + '=' + encodeURIComponent(value);
    
        // Dodaj czas wygaśnięcia:
        str += ';expires=' + expire.toGMTString(); 
    
        // Utwórz cookie:
        document.cookie = str;

    }, // Koniec funkcji setCookie().
    
    // Funkcja pobierania wartości cookies:
    getCookie: function(name) {
        'use strict';

        // Warto wiedzieć, jak długa jest nazwa cookie:
        var len = name.length;
        
        // Podziel cookie na elementy:
        var cookies = document.cookie.split(';');

        // Przejdź przez wartości:
        for (var i = 0, count = cookies.length; i < count; i++) {

            // Usuń początkową spację:
            var value = (cookies[i].slice(0,1) == ' ') ? cookies[i].slice(1) : cookies[i];

			// Zdekoduj wartość:
			value = value.split('=');

            // Sprawdź, czy w tej iteracji pojawiła się poszukiwana nazwa:
            if (decodeURIComponent(value[0]) == name) {

                // Zwróć część po znaku równości:
                return decodeURIComponent(value[1]);

            } // Koniec warunku IF.
            
        } // Koniec pętli FOR.
            
        // Zwróć false, jeśli wcześniej nic nie zwrócono:
        return false;

    }, // Koniec funkcji getCookie().
    
    // Funkcja usuwająca cookie:
    deleteCookie: function(name) {
        'use strict';
        document.cookie = encodeURIComponent(name) + '=;expires=Thu, 01-Jan-1970 00:00:01 GMT';
    } // Koniec funkcji deleteCookie().

}; // Koniec deklaracji COOKIE.