// random.js #2
// Skrypt generuje sześć losowych wartości.

// Funkcja działa jako skrót dla metody document.getElementById().
// Jako jedyny argument przyjmuje identyfikator.
// Zwraca referencję do obiektu DOM.
function $(id) {
    'use strict';
    if (typeof id != 'undefined') {
        return document.getElementById(id);
    }
} // Koniec funkcji $.

function setText(elementId, message) {
    'use strict';
    if ( (typeof elementId == 'string')
    && (typeof message == 'string') ) {
        var output = $(elementId);
		if (output.textContent !== undefined) {
			output.textContent = message;
		} else {
			output.innerText = message;
		}
    } // Koniec instrukcji IF.
} //Koniec funkcji setText().

// Funkcja zwraca losową liczbę.
// Funkcja przyjmuje jeden argument ograniczający maksymalną wartość losowej liczby.
function getRandomNumber(max) {
    'use strict';
    
    // Wygeneruj losową liczbę:
    var n = Math.random();
    
    // Jeśli podano wartość maksymalną, pomnóż przez nią
    // i zamień na liczbę całkowitą:
    if (typeof max == 'number') {
        n *= max;
        n = Math.floor(n);
    }
    
    // Zwróć wygenerowaną liczbę:
    return n;

} // Koniec funkcji getRandomNumber().

// Funkcja wywoływana w momencie wczytania strony WWW.
// Funkcja generuje sześć losowych liczb i wyświetla je w formularzu.
function showNumbers() {
    'use strict';

    // Zmienna do przechowywania szczęśliwych liczb:
    var numbers = '';

    for (var i = 0; i < 6; i++) {
        numbers += getRandomNumber(100) + ' ';
    }

    // Wyświetl liczby:
    setText('output', numbers);

} // Koniec funkcji showNumbers().
window.onload = showNumbers;