<?php // countries.php
// Skrypt zwraca listę krajów pasujący do szukanej frazy.

// Sprypt zwraca dane w formacie JSON:
header('Content-Type: application/json');

// Pusta tablica:
$data = array();

// Źródłowa lista krajów:
$countries = array("Afganistan", "Albania", "Algieria", "Andora", "Angola", "Antigua i Barbuda", "Argentyna", "Armenia", "Australia", "Austria", "Azerbejdżan", "Bahamas", "Bahrajn", "Bangladesz", "Barbados", "Białoruś", "Belgia", "Belize", "Benin", "Bhutan", "Boliwia", "Bośnia i Hercegowina", "Botswana", "Brazylia", "Brunea", "Bułgarii ", "Burkina Faso", "Burundia"," Kambodża", "Kamerun"," Kanada","Cape Verde","Republika Środkowoafrykańska","Czad","Chile","Chiny","Kolumbia","Komory","Kongo","Kostaryka","Chorwacja","Kuba","Cypr","Czechy " "Dania", "Dżibuti", "Dominika", "Dominikana", "Timor Wschodni","Ekwador", "Egipt", "Salwador", "Gwinea Równikowa", "Erytrea", " Estonia","Etiopia","Fidżi","Finlandia","Francja","Gabon","Gambia,","Georgia","Niemcy","Ghana","Grecja","Grenada","Gwatemala","Gwinea","Gwinea Bissau","Gujana","Haiti","Honduras","Węgry","Islandia","Indie","Indonezja","Iran","Irak","Irlandii","Izrael","Włochy","Jamajka","Japonia","Jordan","Kazachstan","Kenia","Kiribati","Korea Północna","Korea Południowa","Kuwejt " "Kirgistan", "Laos", "Łotwa", "Liban", "Lesotho", "Liberia", "Libia", "Liechtenstein", "Litwa", "Luksemburg", "Macedonia", "Madagaskar", " Malawi","Malezja","Malediwy","Mali","Malta","Wyspy Marshalla","Mauretania","Mauritius","Meksyk","Micronesia","Mołdowa","Monako","Mongolia","Maroko","Mozambik","Birma","Namibia","Nauru","Nepa","Holandia","Nowa Zelandia","Nikaragua","Niger","Nigeria","Norwegia " "Oman", "Pakistan", "Palau", "Panama", "Papua-Nowa Gwinea", "Paragwaj", "Peru", "Filipiny", "Polska", "Portugalia", "Katar", "Rumunia" , "Rosja", "Rwanda", "Saint Lucia", "Saint Vincent", "Samoa", "San Marino", "Arabia Saudyjska", "Senegal" "Serbia i Czarnogóra", "Seszele", "Sierra Leone", "Singapore", "Słowacja", "Słowenia", "Wyspy Salomona", "Somalia", "RPA", "Hiszpania", "Sri Lanka" "Sudan", "Surinam", "Suazi", "Szwecja", "Szwajcaria", "Syria", "Tajwan", "Tadżykistan", "Tanzania", "Tajlandia", "Togo", "Tonga", "Trynidad i Tobago","Tunezja","Turcja","Turkmenistan","Tuvalu","Uganda","Ukraina","Zjednoczone Emiraty Arabskie"," Wielka Brytania","USA","Urugwaj","Uzbekistan","Vanuatu","Watykan","Wenezuela","Wietnam","Jemen","Zambia","Zimbabwe");

// Jeśli szukana fraza została przekazana, użyj jej:
if (isset($_GET['term'])) {
	
	// Przejdź w pętli przez wartości, szukając dopasowania:
	foreach ($countries as $country) {
		
		// Dodaj dopasowania do tablicy $data:
		if (stripos($country, $_GET['term']) !== false) $data[] = $country;
		
	} // Koniec FOREACH.
	
} // Koniec IF.

// Zwróć dane w formacie JSON:
echo json_encode($data);