// contact.js
// Skrypt sprawdza formularz kontaktowy przed wysłaniem pod kątem poprawności adresu e-mail i komentarza bez kodu HTML.

// Funkcja wywoływana w momencie wysyłania formularza.
// Funkcja sprawdza dane i zwraca wartość logiczną.
function process() {
    'use strict';

    // Zmienna wskazująca, czy dane sa poprawne:
    var okay = true;

    // Pobierz referencję do wartości formularza:
    var email = document.getElementById('email');
    var comments = document.getElementById('comments');

    // Sprawdź poprawność adresu e-mail:
    if (!email || !email.value
    || (email.value.length < 6)
    || (email.value.indexOf('@') == -1)) {
        okay = false;
        alert('Proszę wprowadzić poprawny adres e-mail!');
    }

    // Sprawdź poprawność komentarza:
    if (!comments || !comments.value
    || (comments.value.indexOf('<') != -1) ) {
        okay = false;
        alert('Proszę wprowadzić treść komentarza bez kodu HTML!');
    }

    // Zwróć status:
    return okay;

} // Koniec funkcji process().

// Konfiguracja wstępna:
function init() {
    'use strict';
    document.getElementById('theForm').onsubmit = process;
} // Koniec funkcji init().
window.onload = init;