// theme.js

// Funkcja wywoływana w celu zmiany wyglądu:
function setTheme(theme) {
    'use strict';

    // Dla arkusza stylów:
    var css = null;
    
    // Utwórz arkusz stylów, jeśli jeszcze nie istnieje:
    if (document.getElementById('cssTheme')) {
        css = document.getElementById('cssTheme');
        css.href = 'css/' + theme + '.css';
    } else { // Utwórz go!
        css = document.createElement('link');
        css.rel = 'stylesheet';
        css.href = 'css/' + theme + '.css';
        css.id = 'cssTheme';
        document.head.appendChild(css);
    }
    
} //Koniec funkcji setTheme().

// Funkcja wywoływana w momencie kliknięcia łącza:
function setThemeCookie(e) {
    'use strict';

    // Pobierz obiekt zdarzenia:
    if (typeof e == 'undefined') e = window.event;

    // Zapobiegnij działaniom domyślnym.
    if (e.preventDefault) {
        e.preventDefault();
    } else {
        e.returnValue = false;
    }

    // Pobierz źródło zdarzenia:
    var target = e.target || e.srcElement;

    // Ustaw cookie:
    var expire = new Date(); // Dziś!
    expire.setDate(expire.getDate() + 7); // Za tydzień!
    COOKIE.setCookie('theme', target.id, expire);
    
    // Uaktualnij wygląd:
    setTheme(target.id);

    return false; // Zapobiegnij działaniom domyślnym.
    
} // Koniec funkcji setThemeCookie().

// Zapewnij podstawową funkcjonalność po wczytaniu strony WWW:
window.onload = function() {
    'use strict';

    // Dodaj procedurę obsługi kliknięcia dla obu łączy:
    document.getElementById('aTheme').onclick = setThemeCookie;
    document.getElementById('bTheme').onclick = setThemeCookie;
    
    // Pobierz wartość zapamiętaną w cookie:
    var theme = COOKIE.getCookie('theme');

    // Jeśli zapamiętano wartość, uaktualnij wygląd:
    if (theme) {
        setThemeCookie(theme);
    }
    
}; // Koniec anonimowej funkcji onload.