// popups.js
// Skrypt tworzy dodatkowe okna dla każdego łącza.

// Funkcja wywoływana po kliknięciu łącza.
function createPopup(e) {
    'use strict';
    
    // Pobierz obiekt zdarzenia:
    if (typeof e == 'undefined') var e = window.event;

    // Pobierz źródło zdarzenia:
    var target = e.target || e.srcElement;

    // Utwórz okno:
    var popup = window.open(target.href, 'PopUp', 'height=100,width=100,top=100,left=100,location=no,resizable=yes,scrollbars=yes');
    
    // Jeśli okno jest otwarte, uczyń je aktywnym:
    if ( (popup !== null) && !popup.closed) {
        popup.focus();
        return false; // Zapobiegnij działaniom domyślnym.
    } else { // Dopuść działanie domyślne.
        return true;
    }
    
} // Koniec funkcji createPopup().

// Zapewnij podstawową funkcjonalność po wczytaniu strony WWW:
window.onload = function() {
    'use strict';
    
    // Dodaj procedurę obsługi do każdego łącza:
    for (var i = 0, count = document.links.length; i < count; i++) {
        document.links[i].onclick = createPopup;
    } // Koniec pętli for.

}; // Koniec funkcji onload.