// words.js
// Skrypt definiuje funkcję sortującą wyrazy w sposób nieuwzględniający wielkości liter.

// Funkcja skrótu:
function $(id) {
    'use strict';
    if (typeof id != 'undefined') {
        return document.getElementById(id);
    }
} // Koniec funkcji $.

// Funkcja fo ustawienia tekstu elementu HTML:
function setText(elementId, message) {
    'use strict';
    if ( (typeof elementId == 'string')
    && (typeof message == 'string') ) {
        var output = $(elementId);
		if (output.textContent !== undefined) {
			output.textContent = message;
		} else {
			output.innerText = message;
		}
    } // Koniec instrukcji IF.
} // Koniec funkcji setText().

// Funkcja sortuje listę słów.
function sortWords() {
    'use strict';

    // Pobierz wyrazy:
    var words = $('words').value;
    
    // Zamień tekst na tablicę wyrazów:
    words = words.split(' ');
    
    // Posortuj wyrazy:
    var sorted = words.map(function(value) {
        return value.toLowerCase();
    }).sort();
    
    // Uaktualnij zawartość elementu HTML:
    setText('output', sorted.join(', '));
        
    // Zwróć false, by zapobiec wysłaniu formularza:
    return false;

} // Koniec funkcji process().

function init() {
    'use strict';
    $('theForm').onsubmit = sortWords;
} // Koniec funkcji init().
window.onload = init;