// today.js #2
// Skrypt wyświetla aktualną datę i czas.

// Funkcja służy do aktualizacji tekstu elementu strony HTML.
// Funkcja przyjmuje dwa argumenty: identyfikator elementu i tekst do wstawienia.
function setText(elementId, message) {
    'use strict';
    
    if ( (typeof elementId == 'string')
    && (typeof message == 'string') ) {
    
        // Pobierz referencję do akapitu:
        var output = document.getElementById(elementId);
    
        // Uaktualnij właściwość innerText lub textContent akapitu:
		if (output.textContent !== undefined) {
			output.textContent = message;
		} else {
			output.innerText = message;
		}
    
    } // Koniec IF.

} // Koniec funkcji setText().

// Wywołaj funkcję w momencie wczytania strony WWW:
function init() {
    'use strict';
    var today = new Date();
    var message = 'Dziś mamy ' + today.toLocaleDateString();
    message += ' i jest godzina ' + today.getHours() + ':' + today.getMinutes();

    // Uaktulnij kod strony:
    setText('output', message);
    
} // Koniec funkcji init().
window.onload = init;