// Generated by CoffeeScript 1.6.3
(function() {
  var XMLAttribute, XMLElement, XMLNode, XMLProcessingInstruction, _,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('lodash-node');

  XMLNode = require('./XMLNode');

  XMLAttribute = require('./XMLAttribute');

  XMLProcessingInstruction = require('./XMLProcessingInstruction');

  module.exports = XMLElement = (function(_super) {
    __extends(XMLElement, _super);

    function XMLElement(parent, name, attributes) {
      XMLElement.__super__.constructor.call(this, parent);
      if (name == null) {
        throw new Error("Missing element name");
      }
      this.name = this.stringify.eleName(name);
      this.children = [];
      this.instructions = [];
      this.attributes = {};
      if (attributes != null) {
        this.attribute(attributes);
      }
    }

    XMLElement.prototype.clone = function() {
      var att, attName, clonedSelf, pi, _i, _len, _ref, _ref1;
      clonedSelf = _.create(XMLElement.prototype, this);
      clonedSelf.attributes = {};
      _ref = this.attributes;
      for (attName in _ref) {
        if (!__hasProp.call(_ref, attName)) continue;
        att = _ref[attName];
        clonedSelf.attributes[attName] = att.clone();
      }
      clonedSelf.instructions = [];
      _ref1 = this.instructions;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        pi = _ref1[_i];
        clonedSelf.instructions.push(pi.clone());
      }
      clonedSelf.children = [];
      this.children.forEach(function(child) {
        var clonedChild;
        clonedChild = child.clone();
        clonedChild.parent = clonedSelf;
        return clonedSelf.children.push(clonedChild);
      });
      return clonedSelf;
    };

    XMLElement.prototype.attribute = function(name, value) {
      var attName, attValue;
      if (_.isObject(name)) {
        for (attName in name) {
          if (!__hasProp.call(name, attName)) continue;
          attValue = name[attName];
          this.attribute(attName, attValue);
        }
      } else {
        if (_.isFunction(value)) {
          value = value.apply();
        }
        if (!this.options.skipNullAttributes || (value != null)) {
          this.attributes[name] = new XMLAttribute(this, name, value);
        }
      }
      return this;
    };

    XMLElement.prototype.removeAttribute = function(name) {
      var attName, _i, _len;
      if (name == null) {
        throw new Error("Missing attribute name");
      }
      if (_.isArray(name)) {
        for (_i = 0, _len = name.length; _i < _len; _i++) {
          attName = name[_i];
          delete this.attributes[attName];
        }
      } else {
        delete this.attributes[name];
      }
      return this;
    };

    XMLElement.prototype.instruction = function(target, value) {
      var insTarget, insValue, instruction, _i, _len;
      if (_.isArray(target)) {
        for (_i = 0, _len = target.length; _i < _len; _i++) {
          insTarget = target[_i];
          this.instruction(insTarget);
        }
      } else if (_.isObject(target)) {
        for (insTarget in target) {
          if (!__hasProp.call(target, insTarget)) continue;
          insValue = target[insTarget];
          this.instruction(insTarget, insValue);
        }
      } else {
        if (_.isFunction(value)) {
          value = value.apply();
        }
        instruction = new XMLProcessingInstruction(this, target, value);
        this.instructions.push(instruction);
      }
      return this;
    };

    XMLElement.prototype.toString = function(options, level) {
      var att, child, indent, instruction, name, newline, pretty, r, space, _i, _j, _len, _len1, _ref, _ref1, _ref2;
      pretty = (options != null ? options.pretty : void 0) || false;
      indent = (options != null ? options.indent : void 0) || '  ';
      newline = (options != null ? options.newline : void 0) || '\n';
      level || (level = 0);
      space = new Array(level + 1).join(indent);
      r = '';
      _ref = this.instructions;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        instruction = _ref[_i];
        r += instruction.toString(options, level + 1);
      }
      if (pretty) {
        r += space;
      }
      r += '<' + this.name;
      _ref1 = this.attributes;
      for (name in _ref1) {
        if (!__hasProp.call(_ref1, name)) continue;
        att = _ref1[name];
        r += att.toString(options);
      }
      if (this.children.length === 0) {
        r += '/>';
        if (pretty) {
          r += newline;
        }
      } else if (pretty && this.children.length === 1 && (this.children[0].value != null)) {
        r += '>';
        r += this.children[0].value;
        r += '</' + this.name + '>';
        r += newline;
      } else {
        r += '>';
        if (pretty) {
          r += newline;
        }
        _ref2 = this.children;
        for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
          child = _ref2[_j];
          r += child.toString(options, level + 1);
        }
        if (pretty) {
          r += space;
        }
        r += '</' + this.name + '>';
        if (pretty) {
          r += newline;
        }
      }
      return r;
    };

    XMLElement.prototype.att = function(name, value) {
      return this.attribute(name, value);
    };

    XMLElement.prototype.ins = function(target, value) {
      return this.instruction(target, value);
    };

    XMLElement.prototype.a = function(name, value) {
      return this.attribute(name, value);
    };

    XMLElement.prototype.i = function(target, value) {
      return this.instruction(target, value);
    };

    return XMLElement;

  })(XMLNode);

}).call(this);
