var express = require('express');
var routes = require('./routes');
var http = require('http');
var path = require('path');
var errorHandler = require('errorhandler');

var app = express();

app.set('port', process.env.PORT || 3000);
app.set('views', __dirname + '/views');
app.set('view engine', 'jade');
app.use(express.static(path.join(__dirname, 'public')));

var domain = require('domain');
var defaultHandler = errorHandler();
app.get('/', routes.index);

app.get('/e', function (req, res, next) {
  var d = domain.create();
  d.on('error', function (error) {
    console.error(error.stack);
    res.send(500, {'error': error.message});
  });
  d.run(function () {
    // Kod podatny na bdy
    throw new Error('Baza danych nie dziaa.');
    // next(new Error('Baza danych nie dziaa.'));
  });
});

app.use(function (error, req, res, next) {
  if (domain.active) {
    console.info('przechwycony w domenie', domain.active);
    domain.active.emit('error', error);
  } else {
    console.info('brak domeny');
    defaultHandler(error, req, res, next);
  }
});

http.createServer(app).listen(app.get('port'), function () {
  console.log('Serwer Express nasuchujcy na porcie ' + app.get('port'));
});
