// Generated by CoffeeScript 1.6.2
var BCSocket, errorMessages,
  __slice = [].slice;

goog.provide('bc.BCSocket');

goog.require('goog.net.BrowserChannel');

goog.require('goog.net.BrowserChannel.Handler');

goog.require('goog.net.BrowserChannel.Error');

goog.require('goog.net.BrowserChannel.State');

errorMessages = {};

errorMessages[goog.net.BrowserChannel.Error.OK] = 'Ok';

errorMessages[goog.net.BrowserChannel.Error.LOGGED_OUT] = 'User is logging out';

errorMessages[goog.net.BrowserChannel.Error.UNKNOWN_SESSION_ID] = 'Unknown session ID';

errorMessages[goog.net.BrowserChannel.Error.STOP] = 'Stopped by server';

errorMessages[goog.net.BrowserChannel.Error.NETWORK] = 'General network error';

errorMessages[goog.net.BrowserChannel.Error.REQUEST_FAILED] = 'Request failed';

errorMessages[goog.net.BrowserChannel.Error.BLOCKED] = 'Blocked by a network administrator';

errorMessages[goog.net.BrowserChannel.Error.NO_DATA] = 'No data from server';

errorMessages[goog.net.BrowserChannel.Error.BAD_DATA] = 'Got bad data from the server';

errorMessages[goog.net.BrowserChannel.Error.BAD_RESPONSE] = 'Got a bad response from the server';

/** @constructor */;

BCSocket = function(url, options) {
  var fireCallback, handler, lastErrorCode, lastSession, reconnect, reconnectTime, reconnectTimer, self, session, setState;

  self = this;
  url || (url = 'channel');
  if (url.match(/:\/\//)) {
    url.replace(/^ws/, 'http');
  }
  options || (options = {});
  if (goog.isArray(options || typeof options === 'string')) {
    options = {};
  }
  reconnectTime = options['reconnectTime'] || 3000;
  setState = function(state) {
    return self.readyState = self['readyState'] = state;
  };
  setState(this.CLOSED);
  session = null;
  lastSession = options.prev;
  fireCallback = function() {
    var args, e, name;

    name = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
    try {
      return typeof self[name] === "function" ? self[name].apply(self, args) : void 0;
    } catch (_error) {
      e = _error;
      if (typeof console !== "undefined" && console !== null) {
        console.error(e.stack);
      }
      throw e;
    }
  };
  handler = new goog.net.BrowserChannel.Handler();
  handler.channelOpened = function(channel) {
    lastSession = session;
    setState(BCSocket.OPEN);
    return fireCallback('onopen');
  };
  lastErrorCode = null;
  handler.channelError = function(channel, errCode) {
    var message;

    message = errorMessages[errCode];
    lastErrorCode = errCode;
    setState(BCSocket.CLOSING);
    try {
      return fireCallback('onerror', message, errCode);
    } catch (_error) {}
  };
  reconnectTimer = null;
  handler.channelClosed = function(channel, pendingMaps, undeliveredMaps) {
    var message, time;

    if (self.readyState === BCSocket.CLOSED) {
      return;
    }
    session = null;
    message = lastErrorCode ? errorMessages[lastErrorCode] : 'Closed';
    setState(BCSocket.CLOSED);
    try {
      fireCallback('onclose', message, pendingMaps, undeliveredMaps);
    } catch (_error) {}
    if (options['reconnect'] && (lastErrorCode !== goog.net.BrowserChannel.Error.STOP && lastErrorCode !== goog.net.BrowserChannel.Error.OK)) {
      time = lastErrorCode === goog.net.BrowserChannel.Error.UNKNOWN_SESSION_ID ? 0 : reconnectTime;
      clearTimeout(reconnectTimer);
      reconnectTimer = setTimeout(reconnect, time);
    }
    return lastErrorCode = null;
  };
  handler.channelHandleArray = function(channel, message) {
    return fireCallback('onmessage', message);
  };
  reconnect = function() {
    if (session) {
      throw new Error('Reconnect() called from invalid state');
    }
    setState(BCSocket.CONNECTING);
    fireCallback('onconnecting');
    clearTimeout(reconnectTimer);
    session = new goog.net.BrowserChannel(options['appVersion'], lastSession != null ? lastSession.getFirstTestResults() : void 0);
    if (options['crossDomainXhr']) {
      session.setSupportsCrossDomainXhrs(true);
    }
    session.setHandler(handler);
    lastErrorCode = null;
    if (options['failFast']) {
      session.setFailFast(true);
    }
    return session.connect("" + url + "/test", "" + url + "/bind", options['extraParams'], lastSession != null ? lastSession.getSessionId() : void 0, lastSession != null ? lastSession.getLastArrayId() : void 0);
  };
  this['open'] = function() {
    if (self.readyState !== self.CLOSED) {
      throw new Error('Already open');
    }
    return reconnect();
  };
  this['close'] = function() {
    clearTimeout(reconnectTimer);
    lastErrorCode = goog.net.BrowserChannel.Error.OK;
    if (self.readyState === BCSocket.CLOSED) {
      return;
    }
    setState(BCSocket.CLOSING);
    return session.disconnect();
  };
  this['sendMap'] = function(map) {
    var _ref;

    if ((_ref = self.readyState) === BCSocket.CLOSING || _ref === BCSocket.CLOSED) {
      throw new Error('Cannot send to a closed connection');
    }
    return session.sendMap(map);
  };
  this['send'] = function(message) {
    return this['sendMap']({
      'JSON': goog.json.serialize(message)
    });
  };
  reconnect();
  return this;
};

BCSocket.prototype['CONNECTING'] = BCSocket['CONNECTING'] = BCSocket.CONNECTING = 0;

BCSocket.prototype['OPEN'] = BCSocket['OPEN'] = BCSocket.OPEN = 1;

BCSocket.prototype['CLOSING'] = BCSocket['CLOSING'] = BCSocket.CLOSING = 2;

BCSocket.prototype['CLOSED'] = BCSocket['CLOSED'] = BCSocket.CLOSED = 3;

(typeof exports !== "undefined" && exports !== null ? exports : window)['BCSocket'] = BCSocket;
