// Generated by CoffeeScript 1.6.3
(function() {
  'use strict';
  var EventEmitter, FSWatcher, fs, isBinary, nodeVersion, sysPath,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __slice = [].slice;

  EventEmitter = require('events').EventEmitter;

  fs = require('fs');

  sysPath = require('path');

  isBinary = require('./is-binary');

  nodeVersion = process.versions.node.substring(0, 3);

  exports.FSWatcher = FSWatcher = (function(_super) {
    __extends(FSWatcher, _super);

    function FSWatcher(options) {
      var _base, _base1, _base2, _base3, _base4, _base5,
        _this = this;
      this.options = options != null ? options : {};
      this.close = __bind(this.close, this);
      this.add = __bind(this.add, this);
      this._handle = __bind(this._handle, this);
      this._handleDir = __bind(this._handleDir, this);
      this._handleFile = __bind(this._handleFile, this);
      this._watch = __bind(this._watch, this);
      this._remove = __bind(this._remove, this);
      this._hasReadPermissions = __bind(this._hasReadPermissions, this);
      this._removeFromWatchedDir = __bind(this._removeFromWatchedDir, this);
      this._addToWatchedDir = __bind(this._addToWatchedDir, this);
      this._getWatchedDir = __bind(this._getWatchedDir, this);
      FSWatcher.__super__.constructor.apply(this, arguments);
      this.watched = Object.create(null);
      this.watchers = [];
      if ((_base = this.options).persistent == null) {
        _base.persistent = false;
      }
      if ((_base1 = this.options).ignoreInitial == null) {
        _base1.ignoreInitial = false;
      }
      if ((_base2 = this.options).ignorePermissionErrors == null) {
        _base2.ignorePermissionErrors = false;
      }
      if ((_base3 = this.options).interval == null) {
        _base3.interval = 100;
      }
      if ((_base4 = this.options).binaryInterval == null) {
        _base4.binaryInterval = 300;
      }
      if ((_base5 = this.options).usePolling == null) {
        _base5.usePolling = true;
      }
      this.enableBinaryInterval = this.options.binaryInterval !== this.options.interval;
      this._ignored = (function(ignored) {
        switch (toString.call(ignored)) {
          case '[object RegExp]':
            return function(string) {
              return ignored.test(string);
            };
          case '[object Function]':
            return ignored;
          default:
            return function() {
              return false;
            };
        }
      })(this.options.ignored);
      Object.freeze(this.options);
    }

    FSWatcher.prototype._getWatchedDir = function(directory) {
      var dir, _base;
      dir = directory.replace(/[\\\/]$/, '');
      return (_base = this.watched)[dir] != null ? (_base = this.watched)[dir] : _base[dir] = [];
    };

    FSWatcher.prototype._addToWatchedDir = function(directory, file) {
      var watchedFiles;
      watchedFiles = this._getWatchedDir(directory);
      return watchedFiles.push(file);
    };

    FSWatcher.prototype._removeFromWatchedDir = function(directory, file) {
      var watchedFiles,
        _this = this;
      watchedFiles = this._getWatchedDir(directory);
      return watchedFiles.some(function(watchedFile, index) {
        if (watchedFile === file) {
          watchedFiles.splice(index, 1);
          return true;
        }
      });
    };

    FSWatcher.prototype._hasReadPermissions = function(stats) {
      return Boolean(4 & parseInt((stats.mode & 0x1ff).toString(8)[0]));
    };

    FSWatcher.prototype._remove = function(directory, item) {
      var fullPath, nestedDirectoryChildren,
        _this = this;
      fullPath = sysPath.join(directory, item);
      nestedDirectoryChildren = this._getWatchedDir(fullPath).slice();
      this._removeFromWatchedDir(directory, item);
      nestedDirectoryChildren.forEach(function(nestedItem) {
        return _this._remove(fullPath, nestedItem);
      });
      fs.unwatchFile(fullPath);
      return this.emit('unlink', fullPath);
    };

    FSWatcher.prototype._watch = function(item, itemType, callback) {
      var basename, directory, options, parent, watcher,
        _this = this;
      if (callback == null) {
        callback = (function() {});
      }
      directory = sysPath.dirname(item);
      basename = sysPath.basename(item);
      parent = this._getWatchedDir(directory);
      options = {
        persistent: this.options.persistent
      };
      if (parent.indexOf(basename) >= 0) {
        return;
      }
      this._addToWatchedDir(directory, basename);
      if (this.options.usePolling) {
        options.interval = this.enableBinaryInterval && isBinary(basename) ? this.options.binaryInterval : this.options.interval;
        return fs.watchFile(item, options, function(curr, prev) {
          if (curr.mtime.getTime() > prev.mtime.getTime()) {
            return callback(item, curr);
          }
        });
      } else {
        watcher = fs.watch(item, options, function(event, path) {
          return callback(item);
        });
        return this.watchers.push(watcher);
      }
    };

    FSWatcher.prototype._handleFile = function(file, stats, initialAdd) {
      var _this = this;
      if (initialAdd == null) {
        initialAdd = false;
      }
      this._watch(file, 'file', function(file, newStats) {
        return _this.emit('change', file, newStats);
      });
      if (!(initialAdd && this.options.ignoreInitial)) {
        return this.emit('add', file, stats);
      }
    };

    FSWatcher.prototype._handleDir = function(directory, initialAdd) {
      var read,
        _this = this;
      read = function(directory, initialAdd) {
        return fs.readdir(directory, function(error, current) {
          var previous;
          if (error != null) {
            return _this.emit('error', error);
          }
          if (!current) {
            return;
          }
          previous = _this._getWatchedDir(directory);
          previous.filter(function(file) {
            return current.indexOf(file) === -1;
          }).forEach(function(file) {
            return _this._remove(directory, file);
          });
          return current.filter(function(file) {
            return previous.indexOf(file) === -1;
          }).forEach(function(file) {
            return _this._handle(sysPath.join(directory, file), initialAdd);
          });
        });
      };
      read(directory, initialAdd);
      return this._watch(directory, 'directory', function(dir) {
        return read(dir, false);
      });
    };

    FSWatcher.prototype._handle = function(item, initialAdd) {
      var _this = this;
      if (this._ignored(item)) {
        return;
      }
      return fs.realpath(item, function(error, path) {
        if (error && error.code === 'ENOENT') {
          return;
        }
        if (error != null) {
          return _this.emit('error', error);
        }
        return fs.stat(path, function(error, stats) {
          if (error != null) {
            return _this.emit('error', error);
          }
          if (_this.options.ignorePermissionErrors && (!_this._hasReadPermissions(stats))) {
            return;
          }
          if (stats.isFile()) {
            _this._handleFile(item, stats, initialAdd);
          }
          if (stats.isDirectory()) {
            return _this._handleDir(item, initialAdd);
          }
        });
      });
    };

    FSWatcher.prototype.emit = function() {
      var args, event;
      event = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
      FSWatcher.__super__.emit.apply(this, arguments);
      if (event === 'add' || event === 'change' || event === 'unlink') {
        return FSWatcher.__super__.emit.apply(this, ['all', event].concat(__slice.call(args)));
      }
    };

    FSWatcher.prototype.add = function(files) {
      var _this = this;
      if (!Array.isArray(files)) {
        files = [files];
      }
      files.forEach(function(file) {
        return _this._handle(file, true);
      });
      return this;
    };

    FSWatcher.prototype.close = function() {
      var _this = this;
      this.watchers.forEach(function(watcher) {
        return watcher.close();
      });
      Object.keys(this.watched).forEach(function(directory) {
        return _this.watched[directory].forEach(function(file) {
          return fs.unwatchFile(sysPath.join(directory, file));
        });
      });
      this.watched = Object.create(null);
      return this;
    };

    return FSWatcher;

  })(EventEmitter);

  exports.watch = function(files, options) {
    return new FSWatcher(options).add(files);
  };

}).call(this);
