var redis 	= require('redis');
var client	= redis.createClient();
var multi = client.multi();

//	Utwórz trzy artykuły z losowymi wyświetleniami przez wielu użytkowników.
var id = 100000; 
while(id--) {
	multi.setbit('artykuł1:dziś', id, Math.round(Math.random(1)));
	multi.setbit('artykuł2:dziś', id, Math.round(Math.random(1)));
	multi.setbit('artykuł3:dziś', id, Math.round(Math.random(1)));
}

multi.exec(function(err) {
	console.log(err);

	//	Zlicz unikatowe odwiedziny artykułu.
	client.bitcount('artykuł1:dziś', function(err, count) {
		console.log(count);
	})
	
	//	Zlicz wyświetlenia wszystkich artykułów.
	client.multi([
		["bitcount", "artykuł1:dziś"],
		["bitcount", "artykuł2:dziś"],
		["bitcount", "artykuł3:dziś"]
	]).exec(function(err, totals) {
		var total = totals.reduce(function(prev, cur) {
			return prev + cur;
		}, 0);
		
		console.log("Łączna liczba wyświetleń: ", total);
	})
	
	// Zlicz, ile artykułów wyświetlił konkretny użytkownik (123) -> 0-3
	client.multi([
		["getbit", "artykuł1:dziś", 123],
		["getbit", "artykuł2:dziś", 123],
		["getbit", "artykuł3:dziś", 123]
	]).exec(function(err, hits) {
		var total = hits.reduce(function(prev, cur) {
			return prev + cur;
		}, 0);
		
		console.log(total);
	})
	
	// Czy użytkownik 123 widział oba artykuły? true || false
	// Zawsze prawdziwe, gdy poprzedni wynik ma wartość 3;
	// czasem prawdziwe, gdy poprzedni wynik ma wartość 2;
	// nigdy nie jest prawdziwe, gdy poprzedni wynik ma wartość mniejszą od 2.
	client.multi([
		['setbit', 'użytkownik123', 123, 1],
		['bitop', 'AND','123:widziałOba','użytkownik123','artykuł1:dziś','artykuł3:dziś'],
		['getbit', '123:widziałOba', 123]
	]).exec(function(err, result) {
		var sawboth = result[2];
		console.log('123 widział oba artykuły: ', !!sawboth);
	});
		
		
	// Zwróć łączną liczbę użytkowników, którzy widzieli choć jeden artykuł (OR).
	client.multi([
		['bitop', 'OR','choćJedenArtykuł','artykuł1:dziś','artykuł2:dziś','artykuł3:dziś'],
		['bitcount', 'choćJedenArtykuł']
	]).exec(function(err, results) {
		console.log("Użytkownicy z przynajmniej jednym artykułem: ", results[1]);
	});
		
	// Znajdź użytkowników, którzy widzieli jeden artykuł, ale nie drugi i poleć im brakujący.
	client.multi([
		['bitop','XOR','polećInny','artykuł1:dziś','artykuł2:dziś'],
		['bitop','AND','poleć:artykuł1','polećInny','artykuł2:dziś'],
		['bitop','AND','poleć:artykuł2','polećInny','artykuł1:dziś'],
		['bitcount', 'polećInny'],
		['bitcount', 'poleć:artykuł1'],
		['bitcount', 'poleć:artykuł2'],
		['del', 'polećInny', 'poleć:artykuł1', 'poleć:artykuł2']
	]).exec(function(err, results) {
		// Zauważ, że wyniki są przesunięte ze względu na wcześniejsze operacje.
		console.log("Nie widzieli obu artykułów: ", results[3]);
		console.log("Widzieli artykuł2; poleć artykuł1: ", results[4]);
		console.log("Widzieli artykuł1; poleć artykuł2: ", results[5]);
	});
});

/*

x = 0011 // 3
y = 0101 // 5

x = x ^ y // x = 0110
y = x ^ y // y = 0110 ^ 0101 = 0011 (zauważ, że jest to oryginalne x)
x = x ^ y // x = 0110 ^ 0011 = 0101 (zauważ, że jest to oryginalne y)

*/
