var http = require('http');
var fs = require('fs');
var CFClient = require('cloudflare');

var config = {
	"token"		: "<Twój token>",
	"email"		: "<Twój adres e-mail>",
	"zone"      : "<Twój identyfikator strefy>",
	"domain"	: "<Twoja domena.pl>",
	"subdomain"	: "www",
	"protocol"	: "http"
};

var cloudflareClient = new CFClient({
	email: config.email,
	key: config.token
});	

function purge(filePath) {
	var head 	= config.protocol + '://';
	var tail	= config.domain + '/' + filePath;
	
	// foo.pl && www.foo.pl to dwa różne wpisy
	var purgeFiles = [
		head + tail,
		head + config.subdomain + '.' + tail
	];

	return cloudflareClient.deleteCache(config.zone, {
		files: purgeFiles
	});
};

var indexFile = './index.html';
http.createServer(function(request, response) {
	var route = request.url;
	if(route === "/index.html") {
		response.writeHead(200, {
			"content-type"		: "text/html",
			"cache-control"		: "max-age=31536000"
		});
		return fs.createReadStream(indexFile).pipe(response);
	}
}).listen(2119);

fs.watch(indexFile, function(event, filename) {
	if(event === "change") {
		purge(filename).then(function() {
			console.log("usunięto plik");
		})
		.catch(function(err) {
			console.log("błąd", err);
		});
	}
});


	
