// Prosty przykład strumienia.

var stream = require('stream');
var Readable = stream.Readable;
var util = require('util');

// Utwórz konstruktor, który będzie instancją Reader.
// Metodę _read dodamy później.
var Reader = function() {
	Readable.call(this);
	this.counter = 0;
}

// Rozszerz Reader interfejsem Readable.
util.inherits(Reader, Readable);

// Zaimplementuj metodę Readable._read.
// Opdopwiada za to, co się stanie po wywołaniu #read na strumieniu Readable.
Reader.prototype._read = function() {
	if(++this.counter > 10) {
		return this.push(null);
	}
	this.push(this.counter.toString());
};

// Utwórz strumień do odczytu, a obsługa zdarzeń zajmie się strumieniem danych.
var reader = new Reader();
reader.setEncoding('utf8');
reader.on('data', function(chunk) {
	console.log(chunk);
});
reader.on('end', function() {
	console.log('--zakończono--');
});
