var redis = require("redis");
var client1 = redis.createClient();
var client2 = redis.createClient();

// Ten kod testujemy.
function nowPublish(channel, msg) {
	client2.publish(channel, msg);
};

describe('Testowanie pub/sub', function() {
	before(function() {
		sinon.spy(client1, "subscribe");
	});

	after(function() {
		client1.subscribe.restore(); 
	});
	
	it('sprawdzenie, czy #subscribe działa', function() {
		client1.subscribe("channel");
		expect(client1.subscribe.calledOnce);
	});
	
	it('sprawdzenie, czy #nowPublish działa', function(done) {
		var callback = sinon.spy();
		client1.subscribe('channel', callback);
		client1.on('subscribe', function() {
			nowPublish('channel', 'komunikat');
			expect(callback.calledWith('komunikat'));
			expect(client1.subscribe.calledTwice);
			done();
		});
	});
});
