var amqp = require('amqp');
var consumer = amqp.createConnection({ host: 'localhost', port: 5672});
var exchange;

consumer.on('_ready', function() {
  exchange = consumer.exchange('node-topic-wymiana', {type: "topic"});
  consumer.queue('node-topic-kolejka', function(q) {
    q.bind(exchange, '#');
	q.subscribe(function(message) {
      // Komunikaty to bufory.
      console.log(message.data.toString('utf8'));
    });
  });
});

consumer.on('ready', function() {

   // Gdy wszystkie trzy kolejki będą gotowe, publikuj.
   var cnt = 3;
   var queueReady = function() {
      if(--cnt > 0) {
         return;
      }
      exchange.publish('zwierzęta.psy.pudelek', 'Pudelek!');
      exchange.publish('zwierzęta.psy.jamnik', 'Jamnik!');
      exchange.publish('zwierzęta.koty.krótkowłose', 'Krótkowłosy kot!');
      exchange.publish('zwierzęta.psy.krótkowłose', 'Krótkowłosy pies!');
      exchange.publish('zwierzęta.inne', 'Inne zwierzę!');
   }

   var exchange = consumer.exchange('tematy', {type: "topic"});
   consumer.queue('kolejka-1', function(q) {
      q.bind(exchange, 'zwierzęta.*.krótkowłose');
      q.subscribe(function(message) {
         console.log('zwierzęta.*.krótkowłose -> ' +
            message.data.toString('utf8'));
      });
      queueReady();
   });

   consumer.queue('kolejka-2', function(q) {
      q.bind(exchange, '#');
      q.subscribe(function(message) {
         console.log('# -> ' + message.data.toString('utf8'));
      });
      queueReady();
   });

   consumer.queue('kolejka-3', function(q) {
      q.bind(exchange, '*.koty.*');
      q.subscribe(function(message) {
         console.log('*.koty.* -> ' + message.data.toString('utf8'));
      });
      queueReady();
   });
});
