var dgram = require('dgram');
var fs = require('fs');

module.exports = function(opts) {

   opts = opts || {};

   var file = opts.file;
   var host = opts.host || 'localhost';
   var port = opts.port || 41234;
   var encoding = opts.encoding || 'utf8';
   var onError = opts.onError || function() {};
   var onReady = opts.onReady || function() {};
   var socket = dgram.createSocket("udp4");
   var writeable = true;
   var _this = this;
   var stream;

   if(!file) {
      throw new Error("Trzeba przekaza aegument #file.");
   }

   stream = fs.createWriteStream(file, {
      flags : 'a+'
   });
   stream.setMaxListeners(0);

   socket.bind(port, host);

   socket.on("listening", onReady);
   socket.on("error", onError);
   socket.on("message", function(msg) {
      _this.log(msg.toString());
   });

   this.log = function(msg) {
      if(!stream) {
         throw new Error('Nie istnieje strumie zapisu do uycia przez logger.');
      }

      try {
         if(typeof msg !== 'string') {
            msg = JSON.stringify(msg);
         }
      } catch(e) {
         return onError("Niepoprawny typ komunikatu przekazany do #log. Musi to by tekst lub obiekt.");
      };

      // Najprawdopodobniej warto w tym miejscu doda ograniczenie ponowie.
      var writer = function() {
         if(!stream.write(msg + '\n', encoding)) {
            stream.once('drain', writer);
         }
      }
      writer();
   };
};
