var net = require('net');
function getConnection(connName){
  var client = net.connect({port: 8107, host:'localhost'}, function() {
    console.log(connName + ' - nawiązano połączenie: ');
    console.log('   lokalny = %s:%s', this.localAddress, this.localPort);
    console.log('   zdalny = %s:%s', this.remoteAddress, this.remotePort);
    this.setTimeout(500);
    this.setEncoding('utf8');
    this.on('data', function(data) {
      console.log(connName + " z serwera: " + data.toString());
      this.end();
    });
    this.on('end', function() {
      console.log(connName + ' - rozłączono klienta');
    });
    this.on('error', function(err) {
      console.log('Błąd gniazda: ', JSON.stringify(err));
    });
    this.on('timeout', function() {
      console.log('Upłynął limit czasu gniazda');
    });
    this.on('close', function() {
      console.log('Zamknięto gniazdo');
    });
  });
  return client;
}
function writeData(socket, data){
  var success = !socket.write(data);
  if (!success){
    (function(socket, data){
      socket.once('drain', function(){
        writeData(socket, data);
      });
    })(socket, data);
  }  
}
var Dwarves = getConnection("Karły");
var Elves = getConnection("Elfy");
var Hobbits = getConnection("Hobbity");
writeData(Dwarves, "Więcej toporów");
writeData(Elves, "Więcej strzał");
writeData(Hobbits, "Więcej fajek");