var MongoClient = require('mongodb').MongoClient;
MongoClient.connect("mongodb://localhost/", function(err, db) {
  var myDB = db.db("words");
  myDB.collection("word_stats", sortItems);
  setTimeout(function(){
    db.close();
  }, 3000);
});
function displayWords(msg, cursor, pretty){
  cursor.toArray(function(err, itemArr){
    console.log("\n"+msg);
    var wordList = [];
    for(var i=0; i<itemArr.length; i++){
      wordList.push(itemArr[i].word);
    }
    console.log(JSON.stringify(wordList, null, pretty));
  });
}
function sortItems(err, words){
  words.find({last:'w'}, function(err, cursor){
    displayWords("Wyrazy zakończone literą w: ", cursor);
  });
  words.find({last:'w'}, {sort:{word:1}}, function(err, cursor){
    displayWords("Wyrazy zakończone literą w posortowane rosnąco: ", cursor);
  });
  words.find({last:'w'}, {sort:{word:-1}}, function(err, cursor){
    displayWords("Wyrazy zakończone literą w posortowane malejąco: ", cursor);
  });
  words.find({first:'b'}, {sort:[['size',-1],['last',1]]}, 
             function(err, cursor){
    displayWords("Wyrazy z literą B jako pierwszą posortowane kolejno według wielkości i ostatniej litery: ", cursor);
  });
  words.find({first:'b'}, {sort:[['last',1],['size',-1]]}, 
             function(err, cursor){
    displayWords("Wyrazy z literą B jako pierwszą posortowane kolejno według ostatniej litery i wielkości: ", cursor);
  });
}