var cluster = require('cluster');
var http = require('http');
var numCPUs = require('os').cpus().length;

if (cluster.isMaster) {
  for (var i = 0; i < numCPUs; i++) {
    cluster.fork();
  }

  cluster.on('exit', function(worker, code, signal) {
    console.log('Proces roboczy ' + worker.process.pid + ' zakończył działanie.');
  });
} else {
  http.Server(function(req, res) {
    res.writeHead(200);
    res.end('Jestem procesem roboczym działającym w procesie ' + process.pid);
  }).listen(8000);
}
