ejs = (function(){

// CommonJS require()

function require(p){
    if ('fs' == p) return {};
    var path = require.resolve(p)
      , mod = require.modules[path];
    if (!mod) throw new Error('Nie udało się żądać "' + p + '"');
    if (!mod.exports) {
      mod.exports = {};
      mod.call(mod.exports, mod, mod.exports, require.relative(path));
    }
    return mod.exports;
  }

require.modules = {};

require.resolve = function (path){
    var orig = path
      , reg = path + '.js'
      , index = path + '/index.js';
    return require.modules[reg] && reg
      || require.modules[index] && index
      || orig;
  };

require.register = function (path, fn){
    require.modules[path] = fn;
  };

require.relative = function (parent) {
    return function(p){
      if ('.' != p.substr(0, 1)) return require(p);
      
      var path = parent.split('/')
        , segs = p.split('/');
      path.pop();
      
      for (var i = 0; i < segs.length; i++) {
        var seg = segs[i];
        if ('..' == seg) path.pop();
        else if ('.' != seg) path.push(seg);
      }

      return require(path.join('/'));
    };
  };


require.register("ejs.js", function(module, exports, require){

/*!
 * EJS
 * Copyright(c) 2012 TJ Holowaychuk <tj@vision-media.ca>
 * MIT Licensed
 */

/**
 * Zależności w postaci modułów.
 */

var utils = require('./utils')
  , fs = require('fs');

/**
 * Wersja biblioteki.
 */

exports.version = '0.7.2';

/**
 * Filtry.
 * 
 * @type Object
 */

var filters = exports.filters = require('./filters');

/**
 * Buforowanie js.
 * 
 * @type Object
 */

var cache = {};

/**
 * Opróżnienie bufora js.
 *
 * @api public
 */

exports.clearCache = function(){
  cache = {};
};

/**
 * Przekształcenie filtrowanego kodu na wywołania funkcji.
 *
 * @param {String} js
 * @return {String}
 * @api private
 */

function filtered(js) {
  return js.substr(1).split('|').reduce(function(js, filter){
    var parts = filter.split(':')
      , name = parts.shift()
      , args = parts.shift() || '';
    if (args) args = ', ' + args;
    return 'filters.' + name + '(' + js + args + ')';
  });
};

/**
 * Ponowne zgłoszenie danego błędu `err` w kontekście
 * `str` szablonu ejs, `filename` i `lineno`.
 *
 * @param {Error} err
 * @param {String} str
 * @param {String} filename
 * @param {String} lineno
 * @api private
 */

function rethrow(err, str, filename, lineno){
  var lines = str.split('\n')
    , start = Math.max(lineno - 3, 0)
    , end = Math.min(lines.length, lineno + 3);

  // Kontekst błędu.
  var context = lines.slice(start, end).map(function(line, i){
    var curr = i + start + 1;
    return (curr == lineno ? ' >> ' : '    ')
      + curr
      + '| '
      + line;
  }).join('\n');

  // Zmiana komunikatu wyjątku.
  err.path = filename;
  err.message = (filename || 'ejs') + ':' 
    + lineno + '\n' 
    + context + '\n\n' 
    + err.message;
  
  throw err;
}

/**
 * Przetworzenie danego ciągu tekstowego `str` ejs, zwrot poleceń funkcji.
 *
 * @param {String} str
 * @return {String}
 * @api public
 */

var parse = exports.parse = function(str, options){
  var options = options || {}
    , open = options.open || exports.open || '<%'
    , close = options.close || exports.close || '%>';

  var buf = [
      "var buf = [];"
    , "\nwith (locals) {"
    , "\n  buf.push('"
  ];
  
  var lineno = 1;

  var consumeEOL = false;
  for (var i = 0, len = str.length; i < len; ++i) {
    if (str.slice(i, open.length + i) == open) {
      i += open.length
  
      var prefix, postfix, line = '__stack.lineno=' + lineno;
      switch (str.substr(i, 1)) {
        case '=':
          prefix = "', escape((" + line + ', ';
          postfix = ")), '";
          ++i;
          break;
        case '-':
          prefix = "', (" + line + ', ';
          postfix = "), '";
          ++i;
          break;
        default:
          prefix = "');" + line + ';';
          postfix = "; buf.push('";
      }

      var end = str.indexOf(close, i)
        , js = str.substring(i, end)
        , start = i
        , n = 0;
        
      if ('-' == js[js.length-1]){
        js = js.substring(0, js.length - 2);
        consumeEOL = true;
      }
        
      while (~(n = js.indexOf("\n", n))) n++, lineno++;
      if (js.substr(0, 1) == ':') js = filtered(js);
      buf.push(prefix, js, postfix);
      i += end - start + close.length - 1;

    } else if (str.substr(i, 1) == "\\") {
      buf.push("\\\\");
    } else if (str.substr(i, 1) == "'") {
      buf.push("\\'");
    } else if (str.substr(i, 1) == "\r") {
      buf.push(" ");
    } else if (str.substr(i, 1) == "\n") {
      if (consumeEOL) {
        consumeEOL = false;
      } else {
        buf.push("\\n");
        lineno++;
      }
    } else {
      buf.push(str.substr(i, 1));
    }
  }

  buf.push("');\n}\nreturn buf.join('');");
  return buf.join('');
};

/**
 * Kompilacja danego ciągu tekstowego `str` ejs na funkcję `Function`.
 *
 * @param {String} str
 * @param {Object} options
 * @return {Function}
 * @api public
 */

var compile = exports.compile = function(str, options){
  options = options || {};
  
  var input = JSON.stringify(str)
    , filename = options.filename
        ? JSON.stringify(options.filename)
        : 'nie zdefiniowano';
  
  // Dodanie użytecznych meta informacji.
  str = [
    'var __stack = { lineno: 1, input: ' + input + ', filename: ' + filename + ' };',
    rethrow.toString(),
    'try {',
    exports.parse(str, options),
    '} catch (err) {',
    '  rethrow(err, __stack.input, __stack.filename, __stack.lineno);',
    '}'
  ].join("\n");
  
  if (options.debug) console.log(str);
  var fn = new Function('locals, filters, escape', str);
  return function(locals){
    return fn.call(this, locals, filters, utils.escape);
  }
};

/**
 * Wygenerowanie danego ciągu tekstowego `str`.
 *
 * Opcje:
 *
 *   - `locals`          Obiekt zmiennych lokalnych.
 *   - `cache`           Skompilowane funkcje będą buforowane, wymaga `filename`.
 *   - `filename`        Używane przez `cache` do buforowania kluczy.
 *   - `scope`           Kontekst wykonywania funkcji.
 *   - `debug`           Wyświetlenie wygenerowanych poleceń funkcji.
 *   - `open`            Znacznik otwierający, domyślnie to "<%"
 *   - `close`           Znacznik zamykający, domyślnie to "%>"
 *
 * @param {String} str
 * @param {Object} options
 * @return {String}
 * @api public
 */

exports.render = function(str, options){
  var fn
    , options = options || {};

  if (options.cache) {
    if (options.filename) {
      fn = cache[options.filename] || (cache[options.filename] = compile(str, options));
    } else {
      throw new Error('Opcja "cache" wymaga "filename".');
    }
  } else {
    fn = compile(str, options);
  }

  options.__proto__ = options.locals;
  return fn.call(options.scope, options);
};

/**
 * Wygenerowanie pliku EJS w podanej lokalizacji `path` i wywołanie `fn(err, str)`.
 *
 * @param {String} path
 * @param {Object|Function} opcje lub wywołanie zwrotne
 * @param {Function} fn
 * @api public
 */

exports.renderFile = function(path, options, fn){
  var key = path + ':string';

  if ('function' == typeof options) {
    fn = options, options = {};
  }

  options.filename = path;

  try {
    var str = options.cache
      ? cache[key] || (cache[key] = fs.readFileSync(path, 'utf8'))
      : fs.readFileSync(path, 'utf8');

    fn(null, exports.render(str, options));
  } catch (err) {
    fn(err);
  }
};

// Obsługa express.

exports.__express = exports.renderFile;

/**
 * Udostępnienie require().
 */

if (require.extensions) {
  require.extensions['.ejs'] = function(module, filename) {
    source = require('fs').readFileSync(filename, 'utf-8');
    module._compile(compile(source, {}), filename);
  };
} else if (require.registerExtension) {
  require.registerExtension('.ejs', function(src) {
    return compile(src, {});
  });
}

}); // Moduł: ejs.js

require.register("filters.js", function(module, exports, require){

/*!
 * EJS - Filters
 * Copyright(c) 2010 TJ Holowaychuk <tj@vision-media.ca>
 * MIT Licensed
 */

/**
 * Pierwszy element celu `obj`.
 */

exports.first = function(obj) {
  return obj[0];
};

/**
 * Ostatni element celu `obj`.
 */

exports.last = function(obj) {
  return obj[obj.length - 1];
};

/**
 * Zmiana na wielką pierwszej litery celu `str`.
 */

exports.capitalize = function(str){
  str = String(str);
  return str[0].toUpperCase() + str.substr(1, str.length);
};

/**
 * Zmiana na małe liter celu `str`.
 */

exports.downcase = function(str){
  return String(str).toLowerCase();
};

/**
 * Zmiana na wielkie liter celu `str`.
 */

exports.upcase = function(str){
  return String(str).toUpperCase();
};

/**
 * Sortowanie celu `obj`.
 */

exports.sort = function(obj){
  return Object.create(obj).sort();
};

/**
 * Sortowanie rosnące celu `obj` przez daną `prop`.
 */

exports.sort_by = function(obj, prop){
  return Object.create(obj).sort(function(a, b){
    a = a[prop], b = b[prop];
    if (a > b) return 1;
    if (a < b) return -1;
    return 0;
  });
};

/**
 * Wielkość lub długość celu `obj`.
 */

exports.size = exports.length = function(obj) {
  return obj.length;
};

/**
 * Dodanie `a` i `b`.
 */

exports.plus = function(a, b){
  return Number(a) + Number(b);
};

/**
 * Odejmowanie `b` od `a`.
 */

exports.minus = function(a, b){
  return Number(a) - Number(b);
};

/**
 * Mnożenie `a` przez `b`.
 */

exports.times = function(a, b){
  return Number(a) * Number(b);
};

/**
 * Dzielenie `a` przez `b`.
 */

exports.divided_by = function(a, b){
  return Number(a) / Number(b);
};

/**
 * Złączenie `obj` z danym `str`.
 */

exports.join = function(obj, str){
  return obj.join(str || ', ');
};

/**
 * Skrócenie `str` do długości `len`.
 */

exports.truncate = function(str, len){
  str = String(str);
  return str.substr(0, len);
};

/**
 * Skrócenie `str` do `n` słów.
 */

exports.truncate_words = function(str, n){
  var str = String(str)
    , words = str.split(/ +/);
  return words.slice(0, n).join(' ');
};

/**
 * Zastąpienie `pattern` przez `substitution` w ciągu tekstowym `str`.
 */

exports.replace = function(str, pattern, substitution){
  return String(str).replace(pattern, substitution || '');
};

/**
 * Umieszczenie `val` na początku `obj`.
 */

exports.prepend = function(obj, val){
  return Array.isArray(obj)
    ? [val].concat(obj)
    : val + obj;
};

/**
 * Dodanie `val` do `obj`.
 */

exports.append = function(obj, val){
  return Array.isArray(obj)
    ? obj.concat(val)
    : obj + val;
};

/**
 * Mapowanie danego `prop`.
 */

exports.map = function(arr, prop){
  return arr.map(function(obj){
    return obj[prop];
  });
};

/**
 * Odwrócenie danego `obj`.
 */

exports.reverse = function(obj){
  return Array.isArray(obj)
    ? obj.reverse()
    : String(obj).split('').reverse().join('');
};

/**
 * Pobranie `prop` danego `obj`.
 */

exports.get = function(obj, prop){
  return obj[prop];
};

/**
 * Konwersja danego `obj` na postać ciagu ciągu tekstowego json.
 */
exports.json = function(obj){
  return JSON.stringify(obj);
};
}); // module: filters.js

require.register("utils.js", function(module, exports, require){

/*!
 * EJS
 * Copyright(c) 2010 TJ Holowaychuk <tj@vision-media.ca>
 * MIT Licensed
 */

/**
 * Unieszkodliwienie danego ciągu tekstowego w `html`.
 *
 * @param {String} html
 * @return {String}
 * @api private
 */

exports.escape = function(html){
  return String(html)
    .replace(/&(?!\w+;)/g, '&amp;')
    .replace(/</g, '&lt;')
    .replace(/>/g, '&gt;')
    .replace(/"/g, '&quot;');
};
 
}); // Moduł: utils.js

 return require("ejs");
})();