var connect = require('connect');

function badMiddleware(req, res, next) {
  next(new Error('Nieprawidłowa metoda pośrednicząca powoduje błąd.'));
}

function errorHandler() {
  var env = process.env.NODE_ENV || 'development';
  return function(err, req, res, next) {
    res.statusCode = 500;
    switch (env) {
      case 'development':
        res.setHeader('Content-Type', 'application/json');
        res.end(JSON.stringify(err));
        break;
      default:
        res.end('Błąd serwera');
    }
  }
}

connect()
  .use(badMiddleware)
  .use(errorHandler)
  .listen(3000);
