var redis = require('redis');
var client = redis.createClient(6379, '127.0.0.1');

client.on('error', function (err) {
  console.log('Błąd ' + err);
});

client.set('kolor', 'czerwony', redis.print);
client.get('kolor', function(err, value) {
  if (err) throw err;
  console.log('Pobrano: ' + value);
});

client.hmset('biwakowanie', {
  'schronienie': 'namiot dwuosobowy',
  'gotowanie': 'kuchenka turystyczna'
}, redis.print);

client.hget('biwakowanie', 'gotowanie', function(err, value) {
  if (err) throw err;
  console.log('Będziemy gotować za pomocą: ' + value);
});

client.hkeys('biwakowanie', function(err, keys) {
  if (err) throw err;
  keys.forEach(function(key, i) {
    console.log(' ' + key);
  });
});

client.lpush('tasks', 'Pomalować rower na czerwono.', redis.print);
client.lpush('tasks', 'Pomalować rower na zielono.', redis.print);
client.lrange('tasks', 0, -1, function(err, items) {
  if (err) throw err; items.forEach(function(item, i) {
    console.log(' ' + item); });
});
