﻿using System;
using System.Linq;
using System.Net;
using Should;
using Tavis.Home;
using WebApiBook.IssueTrackerApi.Infrastructure;
using Xbehave;

namespace WebApiBook.IssueTrackerApp.AcceptanceTests.Features
{
    public class RetreivingHome : HomeFeature
    {
        private readonly Uri _uriHome = new Uri("http://localhost/");

        [Scenario]
        public void RetrievingHomeRepresentation(HomeDocument home)
        {
            "Kiedy zostanie pobrane".
               f(() =>
               {
                   Request.RequestUri = _uriHome;
                   Response = Client.SendAsync(Request).Result;
                   var stream = Response.Content.ReadAsStreamAsync().Result;
                   home = HomeDocument.Parse(stream);
               });
            "Wtedy będzie zwrócony kod stanu '200 OK'".
                f(() => Response.StatusCode.ShouldEqual(HttpStatusCode.OK));
            "Wtedy będzie zwrócone".
                f(() => home.ShouldNotBeNull());
            "Wtedy powinno mieć łącze 'issueprocessor'".
                f(() => home.Resources.FirstOrDefault(l => l.Relation == IssueLinkFactory.Rels.IssueProcessor).ShouldNotBeNull());
            "Wtedy powinno mieć łącze 'issue'".
                f(() => home.Resources.FirstOrDefault(l => l.Relation == IssueLinkFactory.Rels.Issue).ShouldNotBeNull());
            "Wtedy powinno mieć łącze 'issues'".
                f(() => home.Resources.FirstOrDefault(l => l.Relation == IssueLinkFactory.Rels.Issues).ShouldNotBeNull());
            "Wtedy powinno mieć łącze 'search'".
                f(() => home.Resources.FirstOrDefault(l => l.Relation == IssueLinkFactory.Rels.SearchQuery).ShouldNotBeNull());
        }
    }
}
