﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using WebApiBook.IssueTrackerApi.Infrastructure;
using WebApiContrib.CollectionJson;
using CJLink = WebApiContrib.CollectionJson.Link;

namespace WebApiBook.IssueTrackerApi.Models
{
    public class IssuesState : IReadDocument
    {
        public IssuesState()
        {
            Links = new List<Link>();
        }

        public IEnumerable<IssueState> Issues { get; set; }
        public IList<Link> Links { get; private set; }

        Collection IReadDocument.Collection
        {
            get
            {
                var collection = new Collection();
                collection.Href = Links.SingleOrDefault(l => l.Rel == IssueLinkFactory.Rels.Self).Href;
                collection.Links.Add(new CJLink {Rel="profile", Href = new Uri("http://webapibook.net/profile")});
                foreach (var issue in Issues)
                {
                    var item = new Item();
                    foreach (var link in issue.Links)
                    {
                        if (link.Rel == IssueLinkFactory.Rels.Self)
                            item.Href = link.Href;
                        else
                        {
                            item.Links.Add(new CJLink{Href = link.Href, Rel = link.Rel});
                        }
                    }
                    collection.Items.Add(item);
                    item.Data.Add(new Data {Name="Description", Value=issue.Description});
                    item.Data.Add(new Data {Name = "Status", Value = issue.Status});
                    item.Data.Add(new Data {Name="Title", Value = issue.Title});
                }
                var query = new Query { Rel=IssueLinkFactory.Rels.SearchQuery, Href = new Uri("/issue", UriKind.Relative), Prompt="Wyszukiwanie zgłoszenia błędu" };
                query.Data.Add(new Data() { Name = "SearchText", Prompt = "Tekst do dopasowania w polach Title i Description" });
                collection.Queries.Add(query);
                var templateData = collection.Template.Data;
                templateData.Add(new Data() {Name="Description", Prompt="Opis zgłoszenia"});
                templateData.Add(new Data() {Name="Status", Prompt="Stan zgłoszenia (otwarte lub zamknięte)"});
                templateData.Add(new Data() {Name="Title", Prompt="Tytuł zgłoszenia"});
                return collection;
            }
        }
    }
}