/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { HOST, NEXT, PARENT, QUERIES, T_HOST } from './view';
/**
 * Special location which allows easy identification of type. If we have an array which was
 * retrieved from the `LView` and that array has `true` at `TYPE` location, we know it is
 * `LContainer`.
 */
export var TYPE = 1;
/**
 * Below are constants for LContainer indices to help us look up LContainer members
 * without having to remember the specific indices.
 * Uglify will inline these when minifying so there shouldn't be a cost.
 */
export var ACTIVE_INDEX = 2;
// PARENT, NEXT, QUERIES and T_HOST are indices 3, 4, 5 and 6.
// As we already have these constants in LView, we don't need to re-create them.
export var NATIVE = 7;
export var VIEW_REFS = 8;
/**
 * Size of LContainer's header. Represents the index after which all views in the
 * container will be inserted. We need to keep a record of current views so we know
 * which views are already in the DOM (and don't need to be re-added) and so we can
 * remove views from the DOM when they are no longer required.
 */
export var CONTAINER_HEADER_OFFSET = 9;
// Note: This hack is necessary so we don't erroneously get a circular dependency
// failure based on types.
export var unusedValueExportToPlacateAjd = 1;
//# sourceMappingURL=data:application/json;base64,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