﻿using RVAPI.ModelsDTO;
using RVAPI.Services.Interface;
using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;
using System.Web;

namespace RVAPI.Services.Implementation
{
    public class StatisticService : IStatisticService
    {
        private readonly ShiftAssistanceEntities context;
        private readonly IIndicatorsService indicatorsService;

        public StatisticService(ShiftAssistanceEntities context, IIndicatorsService indicatorsService)
        {
            this.context = context;
            this.indicatorsService = indicatorsService;
        }

        public BestShiftsDTO GetBestShift()
        {
            var shifts = context.Shift.Where(s => s.Date.Value.Month == (DateTime.Now.Month == 1 ? DateTime.Now.Month + 11 : DateTime.Now.Month + 1))
                            .Include(i => i.ShiftValue)
                            .Include(i => i.Users)
                            .Include(i => i.Users1)
                            .Include(i => i.Users2)
                            .Include(i => i.Users3);

            Dictionary<int, double?> shiftsDict = new Dictionary<int, double?>();

            foreach (Shift shift in shifts)
            {
                var indicatorday = indicatorsService.GetDayValueByDayNumber(shift.Date.Value.Day);
                var indicatorAB = (shift.AccountBalance == null ? 1 : shift.AccountBalance) * shift.ShiftValue.ShiftValue1 * indicatorday;
                shiftsDict.Add(shift.Id, indicatorAB);

            }

            shiftsDict.OrderByDescending(o => o.Value).ToList();
            BestShiftsDTO bestShiftsList = new BestShiftsDTO() { bestShift = new List<BestShiftDTO>() };

            foreach (var item in shiftsDict)
            {
                var bestShift = new BestShiftDTO()
                {
                    id = item.Key,
                    result = (int)item.Value
                };

                bestShiftsList.bestShift.Add(bestShift);
            }
            return bestShiftsList;
        }

        public BestUsersDTO GetBestUsertByCity()
        {
            var shifts = context.Shift.Include(i => i.ShiftValue).ToList();

            Dictionary<string, double?> shiftsDict = new Dictionary<string, double?>();

            foreach (Shift shift in shifts)
            {
                var indicatorday = indicatorsService.GetDayValueByDayNumber(shift.Date.Value.Day);
                var indicatorAB = (shift.AccountBalance==null ? 1 : shift.AccountBalance) * shift.ShiftValue.ShiftValue1 * indicatorday;

                if (shiftsDict.ContainsKey($"{shift.Users.UserName} {shift.Users.Surname}"))
                {
                    shiftsDict[$"{shift.Users.UserName} {shift.Users.Surname}"] = shiftsDict[$"{shift.Users.UserName} {shift.Users.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.Users.UserName} {shift.Users.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.Users1.UserName} {shift.Users1.Surname}"))
                {
                    shiftsDict[$"{shift.Users1.UserName} {shift.Users1.Surname}"] = shiftsDict[$"{shift.Users1.UserName} {shift.Users1.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.Users1.UserName} {shift.Users1.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.Users2.UserName} {shift.Users2.Surname}"))
                {
                    shiftsDict[$"{shift.Users2.UserName} {shift.Users2.Surname}"] = shiftsDict[$"{shift.Users2.UserName} {shift.Users2.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.Users2.UserName} {shift.Users2.Surname}", indicatorAB);
                };

                if (shiftsDict.ContainsKey($"{shift.Users3.UserName} {shift.Users3.Surname}"))
                {
                    shiftsDict[$"{shift.Users3.UserName} {shift.Users3.Surname}"] = shiftsDict[$"{shift.Users3.UserName} {shift.Users3.Surname}"] + indicatorAB;
                }
                else
                {
                    shiftsDict.Add($"{shift.Users3.UserName} {shift.Users3.Surname}", indicatorAB);
                };
            }

            shiftsDict.OrderByDescending(o => o.Value).ToList();

            BestUsersDTO bestUsersList = new BestUsersDTO() { bestUsers = new List<BestUserDTO>() };

            foreach (var item in shiftsDict)
            {
                var bestUser = new BestUserDTO()
                {
                    username = item.Key,
                    result = (int)item.Value
                };

                bestUsersList.bestUsers.Add(bestUser);
            }
            return bestUsersList;
        }
    }
}