import { Component, OnInit } from '@angular/core';
import { CookieService } from 'ngx-cookie-service';
import { ToastrService } from 'ngx-toastr';
import { IInformations } from '../Interfaces/informations';
import { IInformation } from '../Interfaces/information';
import { IResponse } from '../Interfaces/iresponse';
import { InformationsService } from '../Services/informations.service';

@Component({
  selector: 'app-info',
  templateUrl: './informations.component.html',
  styleUrls: ['./informations.component.css']
})
export class InformationsComponent implements OnInit {

  selectedComponent = 'Table';
  elements: IInformations = {informationList: Array<IInformation>()};
  response: IResponse;
  information: IInformation = {Name: '', Content: '', UserId: this.cookieService.get( 'userId')  , Id: 0};
  informationEdit: IInformation;
  
  constructor(private informationService: InformationsService, private toastr: ToastrService, private cookieService: CookieService) { }

  ngOnInit() {
    this.getData();
  }

  async getData() {
    this.elements = await this.informationService.getInformationsForUser(this.cookieService.get('userMail'));

  }

  addNew() {
    this.selectedComponent = 'AddNewInfo';
  }

  editInfo(infoToEdit: IInformation) {
    this.selectedComponent = 'Edit';
    this.informationEdit = infoToEdit;
  }

 async addNewInfo() {
  this.response = await this.informationService.addInformation(this.information);

    if (this.response.status === 'Success') {
      this.toastr.success('Dodano informacje');
      this.selectedComponent = 'Table';
      this.elements = await this.informationService.getInformationsForUser(this.cookieService.get('userMail'));
    }
  }

  async editInfoInDB() {
    this.response = await this.informationService.editInformation(this.informationEdit);

    if (this.response.status === 'Success') {
      this.toastr.success('Edytowano informacje');
      this.selectedComponent = 'Table';
      this.elements = await this.informationService.getInformationsForUser(this.cookieService.get('userMail'));
    }
  }
}
