import { Component, OnInit } from '@angular/core';
import { BillsService } from '../Services/bills.service';
import { ToastrService } from 'ngx-toastr';
import { CookieService } from 'ngx-cookie-service';
import { IResponse } from '../Interfaces/iresponse';
import { IBill } from '../Interfaces/ibill';
import { IBills } from '../Interfaces/ibills';

@Component({
  selector: 'app-bills',
  templateUrl: './bills.component.html',
  styleUrls: ['./bills.component.css']
})
export class BillsComponent implements OnInit {

  selectedComponent = 'Table';
  lastYear = '';
  headElements = ['Rok', 'Nazwa', 'Stycze', 'Luty', 'Marzec', 'Kwiecien', 'Maj',
  'Czerwiec', 'Lipiec', 'Sierpien', 'Wrzesien', 'Pazdziernik', 'Listopad', 'Grudzien', 'Edytuj'];
  response: IResponse;
  bill: IBill = {Name: '', Year: '', April: '', August: '', December: '', February: '', Id: 0, January: '', July: '',
                 June: '', March: '', May: '', November: '', October: '', September: '', UserId: this.cookieService.get( 'userId')};
  elements: IBills = {billList: Array<IBill>()};
  billEdit: IBill;
  
  constructor(private billsService: BillsService, private toastr: ToastrService, private cookieService: CookieService) { }

  ngOnInit() {
    this.getData();
    this.lastYear = '';
  }

  async getData() {
    this.elements = await this.billsService.getBillsForUser(this.cookieService.get('userMail'));

  }

  addNew() {
    this.selectedComponent = 'AddNewBill';
  }

  editBill(billToEdit: IBill) {
    this.selectedComponent = 'Edit';
    this.billEdit = billToEdit;
  }

 async addNewBill() {
    this.response = await this.billsService.addBill(this.bill);

    if (this.response.status === 'Success') {
      this.toastr.success('Dodano rachunek');
      this.selectedComponent = 'Table';
      this.elements = await this.billsService.getBillsForUser(this.cookieService.get('userMail'));
    }
  }

  async editBillInDB() {
    this.response = await this.billsService.editBill(this.billEdit);

    if (this.response.status === 'Success') {
      this.toastr.success('Edytowano rachunek');
      this.lastYear = '';
      this.selectedComponent = 'Table';
      this.elements = await this.billsService.getBillsForUser(this.cookieService.get('userMail'));
    }
  }

  newLastYear(newYear: string) {
    this.lastYear = newYear;
  }
}
