/**
 * The default directive styling index value for template-based bindings.
 *
 * All host-level bindings (e.g. `hostStyleProp` and `hostClassMap`) are
 * assigned a directive styling index value based on the current directive
 * uniqueId and the directive super-class inheritance depth. But for template
 * bindings they always have the same directive styling index value.
 */
export var DEFAULT_TEMPLATE_DIRECTIVE_INDEX = 0;
//# sourceMappingURL=data:application/json;base64,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