/**
* @license
* Copyright Google Inc. All Rights Reserved.
*
* Use of this source code is governed by an MIT-style license that can be
* found in the LICENSE file at https://angular.io/license
*/
var _stylingMode = 0;
/**
 * Temporary function used to inform the existing styling algorithm
 * code to delegate all styling instruction calls to the new refactored
 * styling code.
 */
export function compilerSetStylingMode(mode) {
    _stylingMode = mode;
}
export function compilerIsNewStylingInUse() {
    return _stylingMode > 0 /* UseOld */;
}
export function compilerAllowOldStyling() {
    return _stylingMode < 2 /* UseNew */;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3R5bGluZ19zdGF0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvbXBpbGVyL3NyYy9yZW5kZXIzL3ZpZXcvc3R5bGluZ19zdGF0ZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0VBTUU7QUFhRixJQUFJLFlBQVksR0FBRyxDQUFDLENBQUM7QUFFckI7Ozs7R0FJRztBQUNILE1BQU0sVUFBVSxzQkFBc0IsQ0FBQyxJQUF5QjtJQUM5RCxZQUFZLEdBQUcsSUFBSSxDQUFDO0FBQ3RCLENBQUM7QUFFRCxNQUFNLFVBQVUseUJBQXlCO0lBQ3ZDLE9BQU8sWUFBWSxpQkFBNkIsQ0FBQztBQUNuRCxDQUFDO0FBRUQsTUFBTSxVQUFVLHVCQUF1QjtJQUNyQyxPQUFPLFlBQVksaUJBQTZCLENBQUM7QUFDbkQsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuKiBAbGljZW5zZVxuKiBDb3B5cmlnaHQgR29vZ2xlIEluYy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbipcbiogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuKi9cblxuLyoqXG4gKiBBIHRlbXBvcmFyeSBlbnVtIG9mIHN0YXRlcyB0aGF0IGluZm9ybSB0aGUgY29yZSB3aGV0aGVyIG9yIG5vdFxuICogdG8gZGVmZXIgYWxsIHN0eWxpbmcgaW5zdHJ1Y3Rpb24gY2FsbHMgdG8gdGhlIG9sZCBvciBuZXdcbiAqIHN0eWxpbmcgaW1wbGVtZW50YXRpb24uXG4gKi9cbmV4cG9ydCBjb25zdCBlbnVtIENvbXBpbGVyU3R5bGluZ01vZGUge1xuICBVc2VPbGQgPSAwLFxuICBVc2VCb3RoT2xkQW5kTmV3ID0gMSxcbiAgVXNlTmV3ID0gMixcbn1cblxubGV0IF9zdHlsaW5nTW9kZSA9IDA7XG5cbi8qKlxuICogVGVtcG9yYXJ5IGZ1bmN0aW9uIHVzZWQgdG8gaW5mb3JtIHRoZSBleGlzdGluZyBzdHlsaW5nIGFsZ29yaXRobVxuICogY29kZSB0byBkZWxlZ2F0ZSBhbGwgc3R5bGluZyBpbnN0cnVjdGlvbiBjYWxscyB0byB0aGUgbmV3IHJlZmFjdG9yZWRcbiAqIHN0eWxpbmcgY29kZS5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGNvbXBpbGVyU2V0U3R5bGluZ01vZGUobW9kZTogQ29tcGlsZXJTdHlsaW5nTW9kZSkge1xuICBfc3R5bGluZ01vZGUgPSBtb2RlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY29tcGlsZXJJc05ld1N0eWxpbmdJblVzZSgpIHtcbiAgcmV0dXJuIF9zdHlsaW5nTW9kZSA+IENvbXBpbGVyU3R5bGluZ01vZGUuVXNlT2xkO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gY29tcGlsZXJBbGxvd09sZFN0eWxpbmcoKSB7XG4gIHJldHVybiBfc3R5bGluZ01vZGUgPCBDb21waWxlclN0eWxpbmdNb2RlLlVzZU5ldztcbn1cbiJdfQ==