﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using SDBWebAPI.Models;
using SDBWebAPI.Services.Interfaces;

namespace SDBWebAPI.Controllers
{
    [Produces("application/json")]
    public class DeployFileController : Controller
    {
        private readonly IDeployFileService deployFileService;

        public DeployFileController(IDeployFileService deployFileService)
        {
            this.deployFileService = deployFileService;
        }

        [Route("api/deployFile/upload/{userId}/{path}")]
        [HttpPost]
        public ResponseDTO UploadFile(int userId, string path)
        {
            return deployFileService.UploadFile(userId, path);
        }
    }
}