﻿using LiveCharts;
using LiveCharts.Dtos;
using LiveCharts.Wpf;
using ShiftAssistance.Models;
using ShiftAssistance.ModelsDTO;
using ShiftAssistance.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace ShiftAssistance
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public readonly IShiftGenerateService shiftGenerateService;
        public readonly IShiftService shiftService;
        public readonly IStatisticsService statisticsService;
        public MainWindow(IShiftGenerateService shiftGenerateService,
                          IShiftService shiftService,
                          IStatisticsService statisticsService)
        {
            //InitializeComponent();
            this.shiftGenerateService = shiftGenerateService;
            this.shiftService = shiftService;
            this.statisticsService = statisticsService;
            InitializeComponent();
        }

        public SeriesCollection SeriesCollectionBS { get; set; }
        public string[] LabelsBS { get; set; }
        public Func<double, string> FormatterBS { get; set; }

        public SeriesCollection SeriesCollectionBW { get; set; }
        public string[] LabelsBW { get; set; }
        public Func<double, string> FormatterBW { get; set; }

        private void CartesianChartBW_Loaded(object sender, RoutedEventArgs e)
        {
            var result = statisticsService.GetBestUser();
            var columnResult = new ChartValues<double>();
            var rowResult = new List<string>();

            foreach (var item in result.bestUsers)
            {
                columnResult.Add(item.result);
                rowResult.Add(item.username);
            }

            SeriesCollectionBW = new SeriesCollection
            {
                new ColumnSeries
                {
                    Values = columnResult
                }
            };


            LabelsBW = rowResult.ToArray();
            FormatterBW = value => value.ToString("N");
            DataContext = this;
        }

        private void CartesianChartBS_Loaded(object sender, RoutedEventArgs e)
        {
            var result = statisticsService.GetBestShift();
            var columnResult = new ChartValues<double>();
            var rowResult = new List<string>();
            foreach (var item in result.bestUsers)
            {
                columnResult.Add(item.result);
                rowResult.Add(item.id.ToString());
            }

            SeriesCollectionBS = new SeriesCollection
            {
                new ColumnSeries
                {
                    Values = columnResult
                }
            };

            //also adding values updates and animates the chart automatically

            LabelsBS = rowResult.ToArray();
            FormatterBS = value => value.ToString("N");
            DataContext = this;
        }

        private void BtnBestShift_Click(object sender, RoutedEventArgs e)
        {
            BtnSSWar.Visibility = Visibility.Hidden;
            BtnSSKra.Visibility = Visibility.Hidden;
            BtnSSPoz.Visibility = Visibility.Hidden;
            BtnSSWro.Visibility = Visibility.Hidden;
            ChartBW.Visibility = Visibility.Hidden;
            ShiftDataGrid.Visibility = Visibility.Hidden;
            ChartBS.Visibility = Visibility.Visible;
            ImgKra.Visibility = Visibility.Hidden;
            ImgPoz.Visibility = Visibility.Hidden;
            ImgWaw.Visibility = Visibility.Hidden;
            ImgWro.Visibility = Visibility.Hidden;
            LabKra.Visibility = Visibility.Hidden;
            LabPoz.Visibility = Visibility.Hidden;
            LabWaw.Visibility = Visibility.Hidden;
            LabWro.Visibility = Visibility.Hidden;
            BtnGenRWar.Visibility = Visibility.Hidden;
            BtnGenRPoz.Visibility = Visibility.Hidden;
            BtnGenRKra.Visibility = Visibility.Hidden;
            BtnGenRWro.Visibility = Visibility.Hidden;
           
        }

        private void BtnBestWorkers_Click(object sender, RoutedEventArgs e)
        {
            BtnSSWar.Visibility = Visibility.Hidden;
            BtnSSKra.Visibility = Visibility.Hidden;
            BtnSSPoz.Visibility = Visibility.Hidden;
            BtnSSWro.Visibility = Visibility.Hidden;
            ChartBS.Visibility = Visibility.Hidden;
            ShiftDataGrid.Visibility = Visibility.Hidden;
            ChartBW.Visibility = Visibility.Visible;
            ImgKra.Visibility = Visibility.Hidden;
            ImgPoz.Visibility = Visibility.Hidden;
            ImgWaw.Visibility = Visibility.Hidden;
            ImgWro.Visibility = Visibility.Hidden;
            LabKra.Visibility = Visibility.Hidden;
            LabPoz.Visibility = Visibility.Hidden;
            LabWaw.Visibility = Visibility.Hidden;
            LabWro.Visibility = Visibility.Hidden;
            BtnGenRWar.Visibility = Visibility.Hidden;
            BtnGenRPoz.Visibility = Visibility.Hidden;
            BtnGenRKra.Visibility = Visibility.Hidden;
            BtnGenRWro.Visibility = Visibility.Hidden;      

        }

        private void BtnShowShedule_Click(object sender, RoutedEventArgs e)
        {
            BtnSSWar.Visibility = Visibility.Visible;
            BtnSSKra.Visibility = Visibility.Visible;
            BtnSSPoz.Visibility = Visibility.Visible;
            BtnSSWro.Visibility = Visibility.Visible;
            ChartBS.Visibility = Visibility.Hidden;
            ChartBW.Visibility = Visibility.Hidden;
            ImgKra.Visibility = Visibility.Hidden;
            ImgPoz.Visibility = Visibility.Hidden;
            ImgWaw.Visibility = Visibility.Hidden;
            ImgWro.Visibility = Visibility.Hidden;
            LabKra.Visibility = Visibility.Hidden;
            LabPoz.Visibility = Visibility.Hidden;
            LabWaw.Visibility = Visibility.Hidden;
            LabWro.Visibility = Visibility.Hidden;
            BtnGenRWar.Visibility = Visibility.Hidden;
            BtnGenRPoz.Visibility = Visibility.Hidden;
            BtnGenRKra.Visibility = Visibility.Hidden;
            BtnGenRWro.Visibility = Visibility.Hidden;
        }

        private void BtnGenerateShedule_Click(object sender, RoutedEventArgs e)
        {
            BtnSSWar.Visibility = Visibility.Hidden;
            BtnSSKra.Visibility = Visibility.Hidden;
            BtnSSPoz.Visibility = Visibility.Hidden;
            BtnSSWro.Visibility = Visibility.Hidden;
            ChartBS.Visibility = Visibility.Hidden;
            ChartBW.Visibility = Visibility.Hidden;
            ShiftDataGrid.Visibility = Visibility.Hidden;
            ImgKra.Visibility = Visibility.Visible;
            ImgPoz.Visibility = Visibility.Visible;
            ImgWaw.Visibility = Visibility.Visible;
            ImgWro.Visibility = Visibility.Visible;
            LabKra.Visibility = Visibility.Visible;
            LabPoz.Visibility = Visibility.Visible;
            LabWaw.Visibility = Visibility.Visible;
            LabWro.Visibility = Visibility.Visible;
            BtnGenRWar.Visibility = Visibility.Visible;
            BtnGenRPoz.Visibility = Visibility.Visible;
            BtnGenRKra.Visibility = Visibility.Visible;
            BtnGenRWro.Visibility = Visibility.Visible;
        }

        private void BtnGenRWar_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(1);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void BtnGenRPoz_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(2);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void BtnGenRKra_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(3);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void BtnGenRWro_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(4);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void BtnSSWar_Click(object sender, RoutedEventArgs e)
        {
            ShiftDataGrid.ItemsSource = ConvertShiftToStringList(shiftService.GatAllForNextMonth(1));
            ShiftDataGrid.Visibility = Visibility.Visible;
        }

        private void BtnSSPoz_Click(object sender, RoutedEventArgs e)
        {
            ShiftDataGrid.ItemsSource = ConvertShiftToStringList(shiftService.GatAllForNextMonth(2));
            ShiftDataGrid.Visibility = Visibility.Visible;
        }

        private void BtnSSKra_Click(object sender, RoutedEventArgs e)
        {
            ShiftDataGrid.ItemsSource = ConvertShiftToStringList(shiftService.GatAllForNextMonth(3));
            ShiftDataGrid.Visibility = Visibility.Visible;
        }

        private void BtnSSWro_Click(object sender, RoutedEventArgs e)
        {
            ShiftDataGrid.ItemsSource = ConvertShiftToStringList(shiftService.GatAllForNextMonth(4));
            ShiftDataGrid.Visibility = Visibility.Visible;
        }

        private IEnumerable<ShiftDTO> ConvertShiftToStringList(IEnumerable<Shift> shiftList)
        {
            var newshiftList = new List<ShiftDTO>();

            foreach (Shift shift in shiftList)
            {
                var newShift = new ShiftDTO()
                {
                    AccountBalance = shift.AccountBalance,
                    CityId = shift.CityId,
                    Id = shift.Id,
                    Date = shift.Date,
                    ShiftValId = shift.ShiftValId,
                    User1Id = shift.User1Id,
                    User2Id = shift.User2Id,
                    User3Id = shift.User3Id,
                    UserId = shift.UserId
                };
                newshiftList.Add(newShift);
            }
            return newshiftList;
        }
    }
}
