﻿using LiveCharts;
using LiveCharts.Wpf;
using RVIWPF.Models;
using RVIWPF.ModelsDTO;
using RVIWPF.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace RVIWPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public readonly IShiftGenerateService shiftGenerateService;
        public readonly IShiftService shiftService;
        public readonly IStatisticsService statisticsService;

        public MainWindow(IShiftGenerateService shiftGenerateService,
                            IShiftService shiftService,
                            IStatisticsService statisticsService)
        {
            this.shiftGenerateService = shiftGenerateService;
            this.shiftService = shiftService;
            this.statisticsService = statisticsService;
            InitializeComponent();
        }

        public SeriesCollection SeriesCollectionBS { get; set; }
        public string[] LabelsBS { get; set; }
        public Func<double, string> FormatterBS { get; set; }
        public SeriesCollection SeriesCollectionBW { get; set; }
        public string[] LabelsBW { get; set; }
        public Func<double, string> FormatterBW { get; set; }

        private void CartesianChartBW_Loaded(object sender, RoutedEventArgs e)
        {
            var result = statisticsService.GetBestUser();
            var columnResult = new ChartValues<double>();
            var rowResult = new List<string>();

            foreach (var item in result.bestUsers)
            {
                columnResult.Add(item.result);
                rowResult.Add(item.username);
            }

            SeriesCollectionBW = new SeriesCollection
            {
                new ColumnSeries
                {
                    Values = columnResult
                }
            };


            LabelsBW = rowResult.ToArray();
            FormatterBW = value => value.ToString("N");
            DataContext = this;
        }

        private void CartesianChartBS_Loaded(object sender, RoutedEventArgs e)
        {
            var result = statisticsService.GetBestShift();
            var columnResult = new ChartValues<double>();
            var rowResult = new List<string>();

            foreach (var item in result.bestUsers)
            {
                columnResult.Add(item.result);
                rowResult.Add(item.id.ToString());
            }

            SeriesCollectionBS = new SeriesCollection
            {
                new ColumnSeries
                {
                    Values = columnResult
                }
            };

            LabelsBS = rowResult.ToArray();
            FormatterBS = value => value.ToString("N");
            DataContext = this;
        }

        private void Button_War_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(1);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void Button_Wro_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(2);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void Button_Poz_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(3);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void Button_Kra_Click(object sender, RoutedEventArgs e)
        {
            var response = shiftGenerateService.GenerateShift(4);

            if (response.Code == "200")
            {
                MessageBox.Show("Wygenerowano grafik");
            }
        }

        private void Button_GZ_Click(object sender, RoutedEventArgs e)
        {
            Button_War.Visibility = Visibility.Visible;
            Button_Wro.Visibility = Visibility.Visible;
            Button_Poz.Visibility = Visibility.Visible;
            Button_Kra.Visibility = Visibility.Visible;
            Ima_War.Visibility = Visibility.Visible;
            Ima_Wro.Visibility = Visibility.Visible;
            Ima_Poz.Visibility = Visibility.Visible;
            Ima_Kra.Visibility = Visibility.Visible;
            Label_War.Visibility = Visibility.Visible;
            Label_Wro.Visibility = Visibility.Visible;
            Label_Poz.Visibility = Visibility.Visible;
            Label_Kra.Visibility = Visibility.Visible;
            ButtonShow_War.Visibility = Visibility.Hidden;
            ButtonShow_Wro.Visibility = Visibility.Hidden;
            ButtonShow_Poz.Visibility = Visibility.Hidden;
            ButtonShow_Kra.Visibility = Visibility.Hidden;
            DataGridShow.Visibility = Visibility.Hidden;
            ChartBS.Visibility = Visibility.Hidden;
            ChartBW.Visibility = Visibility.Hidden;
        }

        private void Button_ZZ_Click(object sender, RoutedEventArgs e)
        {
            ButtonShow_War.Visibility = Visibility.Visible;
            ButtonShow_Wro.Visibility = Visibility.Visible;
            ButtonShow_Poz.Visibility = Visibility.Visible;
            ButtonShow_Kra.Visibility = Visibility.Visible;
            DataGridShow.Visibility = Visibility.Visible;
            Button_War.Visibility = Visibility.Hidden;
            Button_Wro.Visibility = Visibility.Hidden;
            Button_Poz.Visibility = Visibility.Hidden;
            Button_Kra.Visibility = Visibility.Hidden;
            Ima_War.Visibility = Visibility.Hidden;
            Ima_Wro.Visibility = Visibility.Hidden;
            Ima_Poz.Visibility = Visibility.Hidden;
            Ima_Kra.Visibility = Visibility.Hidden;
            Label_War.Visibility = Visibility.Hidden;
            Label_Wro.Visibility = Visibility.Hidden;
            Label_Poz.Visibility = Visibility.Hidden;
            Label_Kra.Visibility = Visibility.Hidden;
            ChartBS.Visibility = Visibility.Hidden;
            ChartBW.Visibility = Visibility.Hidden;
        }

        private void Button_NZ_Click(object sender, RoutedEventArgs e)
        {
            ChartBS.Visibility = Visibility.Visible;
            ButtonShow_War.Visibility = Visibility.Hidden;
            ButtonShow_Wro.Visibility = Visibility.Hidden;
            ButtonShow_Poz.Visibility = Visibility.Hidden;
            ButtonShow_Kra.Visibility = Visibility.Hidden;
            Button_War.Visibility = Visibility.Hidden;
            Button_Wro.Visibility = Visibility.Hidden;
            Button_Poz.Visibility = Visibility.Hidden;
            Button_Kra.Visibility = Visibility.Hidden;
            Ima_War.Visibility = Visibility.Hidden;
            Ima_Wro.Visibility = Visibility.Hidden;
            Ima_Poz.Visibility = Visibility.Hidden;
            Ima_Kra.Visibility = Visibility.Hidden;
            Label_War.Visibility = Visibility.Hidden;
            Label_Wro.Visibility = Visibility.Hidden;
            Label_Poz.Visibility = Visibility.Hidden;
            Label_Kra.Visibility = Visibility.Hidden;
            DataGridShow.Visibility = Visibility.Hidden;
            ChartBW.Visibility = Visibility.Hidden;
        }

        private void Button_NP_Click(object sender, RoutedEventArgs e)
        {
            ChartBW.Visibility = Visibility.Visible;
            ButtonShow_War.Visibility = Visibility.Hidden;
            ButtonShow_Wro.Visibility = Visibility.Hidden;
            ButtonShow_Poz.Visibility = Visibility.Hidden;
            ButtonShow_Kra.Visibility = Visibility.Hidden;
            Button_War.Visibility = Visibility.Hidden;
            Button_Wro.Visibility = Visibility.Hidden;
            Button_Poz.Visibility = Visibility.Hidden;
            Button_Kra.Visibility = Visibility.Hidden;
            Ima_War.Visibility = Visibility.Hidden;
            Ima_Wro.Visibility = Visibility.Hidden;
            Ima_Poz.Visibility = Visibility.Hidden;
            Ima_Kra.Visibility = Visibility.Hidden;
            Label_War.Visibility = Visibility.Hidden;
            Label_Wro.Visibility = Visibility.Hidden;
            Label_Poz.Visibility = Visibility.Hidden;
            Label_Kra.Visibility = Visibility.Hidden;
            DataGridShow.Visibility = Visibility.Hidden;
            ChartBS.Visibility = Visibility.Hidden;
        }

        private void ButtonShow_War_Click(object sender, RoutedEventArgs e)
        {
            DataGridShow.ItemsSource = ConvertShiftToStringList(shiftService.GatShift(1));
        }

        private void ButtonShow_Wro_Click(object sender, RoutedEventArgs e)
        {
            DataGridShow.ItemsSource = ConvertShiftToStringList(shiftService.GatShift(2));
        }

        private void ButtonShow_Poz_Click(object sender, RoutedEventArgs e)
        {
            DataGridShow.ItemsSource = ConvertShiftToStringList(shiftService.GatShift(3));
        }

        private void ButtonShow_Kra_Click(object sender, RoutedEventArgs e)
        {
            DataGridShow.ItemsSource = ConvertShiftToStringList(shiftService.GatShift(4));
        }

        private IEnumerable<ShiftDTO> ConvertShiftToStringList(IEnumerable<Shift> shiftList)
        {
            var newshiftList = new List<ShiftDTO>();

            foreach (Shift shift in shiftList)
            {
                var newShift = new ShiftDTO()
                {
                    AccountBalance = shift.AccountBalance,
                    CityId = shift.CityId,
                    Id = shift.Id,
                    Date = shift.Date,
                    ShiftValId = shift.ShiftValId,
                    User1Id = shift.User1Id,
                    User2Id = shift.User2Id,
                    User3Id = shift.User3Id,
                    UserId = shift.UserId
                };
                newshiftList.Add(newShift);
            }
            return newshiftList;
        }
    }
}
