import { Component, OnInit } from '@angular/core';
import { ShiftsService } from '../shift.service';
import { IShifts } from '../ishifts';
import { IShift } from '../ishift';

@Component({
  selector: 'app-show-shift-shedule',
  templateUrl: './show-shift-shedule.component.html',
  styleUrls: ['./show-shift-shedule.component.css']
})
export class ShowShiftSheduleComponent implements OnInit {

  constructor(private shiftsService: ShiftsService) { }

  shifts: IShifts = { bestUsers  : Array<IShift>()};
  headElements = ['Id', 'Date', 'ShiftNumber', 'CityId', 'UserId', 'User2Id', 'User3Id', 'User4Id', 'AccountBalance'];

  ngOnInit() {
  }

  async getShiftReport(cityId: number) {
      this.shifts.bestUsers = await this.shiftsService.showShift(cityId.toString());
  }
}
