import { Injectable } from '@angular/core';
import { HttpClient, HttpParams, HttpHeaders } from '@angular/common/http';
import { Iresponse } from './iresponse';
import { IShift } from './ishift';

@Injectable({
  providedIn: 'root'
})
export class ShiftsService {

  appUrl = 'https://localhost:44351'; // Address to change

  constructor(private http: HttpClient) {}

  generateShift(cityId: string) {
    let paramss = new HttpParams();
    paramss = paramss.append('cityName', cityId);

    return this.http.get<Iresponse>(this.appUrl + '/shift/generateshift' , {params: paramss}).toPromise();
   }

   showShift(cityId: string) {
    let paramss = new HttpParams();
    paramss = paramss.append('cityId', cityId);
    let head = new HttpHeaders();
    head.append("Access-Control-Allow-Origin", "*");
    
    return this.http.get<Array<IShift>>(this.appUrl + '/shift/ShowShedule' , {params: paramss, headers: head}).toPromise();
   }
}