﻿using RVAPI.ModelsDTO;
using RVAPI.Services.Interface;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace RVAPI.Services.Implementation
{
    public class ShiftService : IShiftService
    {
        private readonly ShiftAssistanceEntities context;

        public ShiftService(ShiftAssistanceEntities context)
        {
            this.context = context;
        }

        public ResponseDTO Add(Shift shift)
        {
            try
            {
                context.Shift.Add(shift);
                context.SaveChanges();
            }
            catch (Exception e)
            {
                return new ResponseDTO() { Code = "400", Message = e.Message, Status = "Failed" };
            }
            return new ResponseDTO() { Code = "200", Message = "Added shift to DB", Status = "Success" };
        }

        public IList<Shift> ShowShedule(int CityId)
        {
            ShiftsDTO shiftsDTO = new ShiftsDTO();
            shiftsDTO.shiftList = new List<Shift>();
            var shiftsList = context.Shift.Where(s => s.CityId == CityId && s.Date.Value.Month == DateTime.Now.Month+1).ToArray();
            foreach (var item in shiftsList)
            {
                var shift = new Shift()
                {
                    AccountBalance = item.AccountBalance,
                    CityId = item.CityId,
                    Id = item.Id,
                    Date = item.Date,
                    ShiftNumber = item.ShiftNumber,
                    User2Id = item.User2Id,
                    UserId = item.UserId,
                    User3Id = item.User3Id,
                    User4Id = item.User4Id
                };
                shiftsDTO.shiftList.Add(shift);
            }
            return shiftsDTO.shiftList;
        }
    }
}