import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { IResponseafterLogin } from '../Interfaces/iresponseafter-login';
import { IUser } from '../Interfaces/iuser';



@Injectable({
  providedIn: 'root'
})
export class LoginServiceService {

  appUrl = 'https://localhost:44305'; //Address to change

  constructor(private http: HttpClient) {}

  checkIsUser(user: IUser) {
    const headers = new HttpHeaders({
      'Content-Type': 'application/json'});
    const options = { headers: headers };

    return this.http.post<IResponseafterLogin>(this.appUrl + '/Register/Login', user, options).toPromise();
   }

   register(user: IUser) {
    const headers = new HttpHeaders({
      'Content-Type': 'application/json'});
    const options = { headers: headers };

    return this.http.post<IResponseafterLogin>(this.appUrl + '/Register/Register', user, options).toPromise();
   }

}

