/**
 * Browser target options
 */
export interface Schema {
    /**
     * Build using Ahead of Time compilation.
     */
    aot?: boolean;
    /**
     * List of static application assets.
     */
    assets?: AssetPattern[];
    /**
     * Base url for the application being built.
     */
    baseHref?: string;
    /**
     * Budget thresholds to ensure parts of your application stay within boundaries which you
     * set.
     */
    budgets?: Budget[];
    /**
     * Enables '@angular-devkit/build-optimizer' optimizations when using the 'aot' option.
     */
    buildOptimizer?: boolean;
    /**
     * Use a separate bundle containing code used across multiple bundles.
     */
    commonChunk?: boolean;
    /**
     * Define the crossorigin attribute setting of elements that provide CORS support.
     */
    crossOrigin?: CrossOrigin;
    /**
     * Delete the output path before building.
     */
    deleteOutputPath?: boolean;
    /**
     * URL where files will be deployed.
     */
    deployUrl?: string;
    /**
     * Enables conditionally loaded ES2015 polyfills.
     * @deprecated This will be determined from the list of supported browsers specified in the
     * 'browserslist' file.
     */
    es5BrowserSupport?: boolean;
    /**
     * Output in-file eval sourcemaps.
     * @deprecated
     */
    evalSourceMap?: boolean;
    /**
     * Extract css from global styles into css files instead of js ones.
     */
    extractCss?: boolean;
    /**
     * Extract all licenses in a separate file.
     */
    extractLicenses?: boolean;
    /**
     * Replace files with other files in the build.
     */
    fileReplacements?: FileReplacement[];
    /**
     * Run the TypeScript type checker in a forked process.
     */
    forkTypeChecker?: boolean;
    /**
     * Localization file to use for i18n.
     */
    i18nFile?: string;
    /**
     * Format of the localization file specified with --i18n-file.
     */
    i18nFormat?: string;
    /**
     * Locale to use for i18n.
     */
    i18nLocale?: string;
    /**
     * How to handle missing translations for i18n.
     */
    i18nMissingTranslation?: string;
    /**
     * The name of the index HTML file.
     */
    index: string;
    /**
     * List of additional NgModule files that will be lazy loaded. Lazy router modules will be
     * discovered automatically.
     */
    lazyModules?: string[];
    /**
     * The full path for the main entry point to the app, relative to the current workspace.
     */
    main: string;
    /**
     * Use file name for lazy loaded chunks.
     */
    namedChunks?: boolean;
    /**
     * Path to ngsw-config.json.
     */
    ngswConfigPath?: string;
    /**
     * Enables optimization of the build output.
     */
    optimization?: OptimizationUnion;
    /**
     * Define the output filename cache-busting hashing mode.
     */
    outputHashing?: OutputHashing;
    /**
     * The full path for the new output directory, relative to the current workspace.
     *
     * By default, writes output to a folder named dist/ in the current project.
     */
    outputPath: string;
    /**
     * Enable and define the file watching poll time period in milliseconds.
     */
    poll?: number;
    /**
     * The full path for the polyfills file, relative to the current workspace.
     */
    polyfills?: string;
    /**
     * Do not use the real path when resolving modules.
     */
    preserveSymlinks?: boolean;
    /**
     * Output profile events for Chrome profiler.
     * @deprecated Use "NG_BUILD_PROFILING" environment variable instead.
     */
    profile?: boolean;
    /**
     * Log progress to the console while building.
     */
    progress?: boolean;
    /**
     * Change root relative URLs in stylesheets to include base HREF and deploy URL. Use only
     * for compatibility and transition. The behavior of this option is non-standard and will be
     * removed in the next major release.
     * @deprecated
     */
    rebaseRootRelativeCssUrls?: boolean;
    /**
     * The path where style resources will be placed, relative to outputPath.
     */
    resourcesOutputPath?: string;
    /**
     * Global scripts to be included in the build.
     */
    scripts?: ExtraEntryPoint[];
    /**
     * Generates a service worker config for production builds.
     */
    serviceWorker?: boolean;
    /**
     * Show circular dependency warnings on builds.
     */
    showCircularDependencies?: boolean;
    /**
     * Flag to prevent building an app shell.
     * @deprecated
     */
    skipAppShell?: boolean;
    /**
     * Output sourcemaps.
     */
    sourceMap?: SourceMapUnion;
    /**
     * Generates a 'stats.json' file which can be analyzed using tools such as
     * 'webpack-bundle-analyzer'.
     */
    statsJson?: boolean;
    /**
     * Options to pass to style preprocessors.
     */
    stylePreprocessorOptions?: StylePreprocessorOptions;
    /**
     * Global styles to be included in the build.
     */
    styles?: ExtraEntryPoint[];
    /**
     * Enables the use of subresource integrity validation.
     */
    subresourceIntegrity?: boolean;
    /**
     * The full path for the TypeScript configuration file, relative to the current workspace.
     */
    tsConfig: string;
    /**
     * Use a separate bundle containing only vendor libraries.
     */
    vendorChunk?: boolean;
    /**
     * Resolve vendor packages sourcemaps.
     * @deprecated
     */
    vendorSourceMap?: boolean;
    /**
     * Adds more details to output logging.
     */
    verbose?: boolean;
    /**
     * Run build when files change.
     */
    watch?: boolean;
    /**
     * TypeScript configuration for Web Worker modules.
     */
    webWorkerTsConfig?: string;
}
export declare type AssetPattern = AssetPatternClass | string;
export interface AssetPatternClass {
    /**
     * The pattern to match.
     */
    glob: string;
    /**
     * An array of globs to ignore.
     */
    ignore?: string[];
    /**
     * The input directory path in which to apply 'glob'. Defaults to the project root.
     */
    input: string;
    /**
     * Absolute path within the output.
     */
    output: string;
}
export interface Budget {
    /**
     * The baseline size for comparison.
     */
    baseline?: string;
    /**
     * The threshold for error relative to the baseline (min & max).
     */
    error?: string;
    /**
     * The maximum threshold for error relative to the baseline.
     */
    maximumError?: string;
    /**
     * The maximum threshold for warning relative to the baseline.
     */
    maximumWarning?: string;
    /**
     * The minimum threshold for error relative to the baseline.
     */
    minimumError?: string;
    /**
     * The minimum threshold for warning relative to the baseline.
     */
    minimumWarning?: string;
    /**
     * The name of the bundle.
     */
    name?: string;
    /**
     * The type of budget.
     */
    type: Type;
    /**
     * The threshold for warning relative to the baseline (min & max).
     */
    warning?: string;
}
/**
 * The type of budget.
 */
export declare enum Type {
    All = "all",
    AllScript = "allScript",
    Any = "any",
    AnyScript = "anyScript",
    Bundle = "bundle",
    Initial = "initial"
}
/**
 * Define the crossorigin attribute setting of elements that provide CORS support.
 */
export declare enum CrossOrigin {
    Anonymous = "anonymous",
    None = "none",
    UseCredentials = "use-credentials"
}
export interface FileReplacement {
    replace?: string;
    replaceWith?: string;
    src?: string;
    with?: string;
}
/**
 * Enables optimization of the build output.
 */
export declare type OptimizationUnion = boolean | OptimizationClass;
export interface OptimizationClass {
    /**
     * Enables optimization of the scripts output.
     */
    scripts?: boolean;
    /**
     * Enables optimization of the styles output.
     */
    styles?: boolean;
}
/**
 * Define the output filename cache-busting hashing mode.
 */
export declare enum OutputHashing {
    All = "all",
    Bundles = "bundles",
    Media = "media",
    None = "none"
}
export declare type ExtraEntryPoint = ExtraEntryPointClass | string;
export interface ExtraEntryPointClass {
    /**
     * The bundle name for this extra entry point.
     */
    bundleName?: string;
    /**
     * If the bundle will be referenced in the HTML file.
     */
    inject?: boolean;
    /**
     * The file to include.
     */
    input: string;
    /**
     * If the bundle will be lazy loaded.
     */
    lazy?: boolean;
}
/**
 * Output sourcemaps.
 */
export declare type SourceMapUnion = boolean | SourceMapClass;
export interface SourceMapClass {
    /**
     * Output sourcemaps used for error reporting tools.
     */
    hidden?: boolean;
    /**
     * Output sourcemaps for all scripts.
     */
    scripts?: boolean;
    /**
     * Output sourcemaps for all styles.
     */
    styles?: boolean;
    /**
     * Resolve vendor packages sourcemaps.
     */
    vendor?: boolean;
}
/**
 * Options to pass to style preprocessors.
 */
export interface StylePreprocessorOptions {
    /**
     * Paths to include. Paths will be resolved to project root.
     */
    includePaths?: string[];
}
