﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using R_II_Test_API.ModelsDTO;
using R_II_Test_API.Services.Interfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace R_II_Test_API.Controllers
{
    public class BillController : Controller
    {
        private readonly IBillsService billService;
        private readonly ILogger<BillController> logger;

        public BillController(IBillsService billService, ILogger<BillController> logger)
        {
            this.billService = billService;
            this.logger = logger;
        }

        [HttpPost]
        [Route("/api/bill/add")]
        public IActionResult AddBill([FromBody]BillDTO billDTO)
        {
            logger.LogInformation("Executing AddBill controller");

            return Ok(billService.AddBill(billDTO));
        }

        [HttpPut]
        [Route("/api/bill/edit")]
        public ActionResult EditBill([FromBody]BillDTO billDTO)
        {
            logger.LogInformation("Executing EditBill controller");

            return Ok(billService.EditBill(billDTO));
        }

        [AllowAnonymous]
        [HttpDelete]
        [Route("/api/bill/delete/{mail}")]
        public IActionResult DeleteBill(string mail)
        {
            logger.LogInformation("Executing DeleteBill controller");

            return Ok(billService.DeleteBill(mail));
        }

        [AllowAnonymous]
        [HttpGet]
        [Route("/api/bill/getAll/{mail}")]
        public IActionResult GetAllBillByUser(string mail)
        {
            logger.LogInformation("Executing GetAllBillByUser controller");

            return Ok(billService.GetAllBillByUser(mail));
        }
    }
}
