# Rozdział 9. - Laboratorium - Przykładowe rozwiązanie

Aplikacja listy zadań używana w tym laboratorium już dysponuje wbudowanym wsparciem dla Prometheusa. Aby się o tym przekonać, wykonaj następujące polecenie:

```
docker container dun -d -p 8050:80 diamol/ch09-todo-list
```

A następnie wyświetl w przeglądarce stronę http://localhost:8050 i wpisz w aplikacji kilka zadań do wykonania.

Następnie wyświetl w przeglądarce na stronę http://localhost:8050/metrics, aby obejrzeć metryki Prometheusa.

## Niestandardowy obraz Prometheusa

Prometheus musi zostać skonfigurowany w celu pobierania danych z aplikacji listy zadań.

Moje dane konfiguracyjne Prometheusa znajdziesz w pliku [prometheus.yml](./prometheus/prometheus.yml):

```
  - job_name: "todo-list"
    metrics_path: /metrics
    static_configs:
      - targets: ["todo-list"]
```

Towarzyszy mu prosty plik [Dockerfile](./prometheus/Dockerfile), który pozwala wczytać ten plik konfiguracyjny do obrazu Dockera.

## Niestandardowy obraz Grafany

Po uruchomieniui kontenerów z aplikacją listy zadań i Prometheusem, zbudowałem pulpit uruchamiając w tym celu kontener Grafany. Do pulpitu dodałem trzy proste panele, co pozwoliło mi uzyskać następujące efekty:

![Grafana dashboard for the to-do list app](./dashboard.png)

Zapytania PromQL są bardzo proste - nie trzeba w nich stosować ani agragacji danych, ani filtrowania:

- `todo_tasks_created_total`
- `http_requests_received_total`
- `http_requests_in_progress`

Następnie wyeksportowałem kod JSON i zapisałem go w pliku [dashboard.json](./grafana/dashboard.json).


Plik [Dockerfile](./grafana/Dockerfile) dla obraz z Grafaną pakuje plik z definicją pulpitu oraz informacje o źródle danych Prometheusa (robi to w dokładnie taki sam sposób jak ćwiczenia w rozdziale 9.).

## Uruchamianie aplikacji z użyciem metryk

Ten plik [docker-compose.yml](docker-compose.yml) uruchamia aplikację oraz kontenery z Prometheusem i Grafaną.

Tym poleceniem uruchomisz wszystkie kontenery:

```
docker-compose up -d
```

Teraz wyświetl w przeglądarce stronę http://localhost:8050, dodaj parę zadań i sprawdź pulpit dostępny na stronie http://localhost:3000.
